define('feature/issues/issue-view',
    [
        './issue.css',
        '../../widget/aui-buttons-pointy/aui-buttons-pointy.css',
        '../../layout/base/base.soy',
        'zepto',
        'underscore',
        'layout/base/page-view',
        'layout/header/header-view',
        'layout/loading-overlay/loading-overlay-view',
        'feature/issues/comments/comments-view',
        'feature/issues/comments/add-comment-view',
        'feature/issues/fields/description-view',
        'feature/issues/fields/main-fields-view',
        'feature/issues/fields/all-fields-view',
        'feature/issues/issue-header-view',
        'feature/issues/issue-actions-view',
        'feature/open-app-button/open-app-button',
        'util/router',
        'util/events',
        'util/app-data'
    ],
    function (
        css,
        css2,
        BaseTemplates,
        $,
        _,
        PageView,
        HeaderView,
        LoadingOverlayView,
        CommentView,
        AddCommentView,
        DescriptionView,
        MainFieldsView,
        AllFieldsView,
        IssueHeaderView,
        IssueActionView,
        OpenAppButtonView,
        router,
        events,
        appData) {

        return PageView.extend({
            className: 'card issue aui-page-panel user-content',

            desktopUrl: function () {
                return appData.get('context-path') + '/browse/' + this.model.get('key');
            },

            pageTitle: function () {
                return '[#' + this.model.get('key') + '] ' + this.model.get('fields').summary;
            },

            events: {
                'click .details-button': 'detailsModeSwitch',
                'click .action-menu-button': 'toggleActionMenu',
                'click .card.issue.aui-page-panel': 'actionMenuBlur',
                'click .comment-body img': 'openImage',
                'click .description-body img': 'openImage'
            },

            _updateData: function () {
                this.addComments = null;

                // The comments view
                const comments = this.model.get('renderedFields').comment;
                const canAddComment = this.model.get('permissions').canAddComment;
                // Only show the comment box if there are comments or an add comment box
                if (comments.total > 0 || canAddComment) {
                    if (!this.comments) {
                        this.comments = new CommentView({
                            model: this.model,
                            commentId: this.commentId
                        });
                    }
                } else if (this.comments) {
                    this.comments.close();
                    this.comments = null;
                }
                // Permission check
                if (canAddComment && !this.addComments) {
                    this.addComments = new AddCommentView({
                        issueKey: this.model.get('key'),
                        model: this.model
                    });
                } else if (this.addComments) {
                    this.addComments.close();
                    this.addComments = null;
                }
            },

            initialize: function (options) {
                this.issueHeader = new IssueHeaderView({
                    model: this.model
                });

                // Initialise the header
                const headerAttributes = {
                    el: this.$el,
                    title: this.model.key,
                    actionsView: this.issueHeader
                };
                if (this.options.showBackButton) {
                    // @i18n
                    _.extend(headerAttributes, {backText: AJS.I18n.getText('jira.mobile.back.button')});
                }
                this.header = new HeaderView(headerAttributes);
                this.loadingOverlay = new LoadingOverlayView();
                // the actions menu
                this.issueActions = new IssueActionView({
                    parent: this,
                    model: this.model
                });

                // Initialise the main view
                this.mainFields = new MainFieldsView({
                    model: this.model
                });
                // The details view
                this.allFieldsView = new AllFieldsView({
                    model: this.model
                });
                this.descriptionView = new DescriptionView({
                    model: this.model
                });

                this.openAppButton = new OpenAppButtonView({
                    issueKey: this.model.attributes.key,
                    page: 'issue'
                });

                // Selected comment
                this.commentId = options.commentId;

                // Init comments
                this._updateData();
            },

            render: function () {
                this.$el.empty();
                this.header.render();
                this.loadingOverlay.render();

                this.issueActions.closeActionsIfOpen();
                this.$el.append(this.issueActions.render().$el);

                this.$el.append(this.mainFields.render().$el);
                this.$el.append(this.allFieldsView.render().$el);
                this.$el.append(this.descriptionView.render().$el);
                if (this.comments){
                    this.$el.append(this.comments.render().$el);
                }
                if (this.addComments) {
                    this.$el.append(this.addComments.render().$el);
                }
                this.$el.append(BaseTemplates.atlasFooter());

                this.openAppButton.render();
            },

            toggleActionMenu: function () {
                this.issueActions.toggleShowActions();
            },

            actionMenuBlur: function (e) {
                const $target = $(e.target);
                // If the user clicked inside the action menu, then we don't want to close it
                if($target.closest('.issue-actions, .header').length === 0) {
                    this.issueActions.closeActionsIfOpen();
                }
            },

            openImage: function(e) {
                const $target = $(e.target);
                const src = $target.attr('src');
                if (src) {
                    document.location.href = src;
                }
            },

            detailsModeSwitch :function () {
                this.allFieldsView.setShow(!this.allFieldsView.show);
                if (this.allFieldsView.show) {
                    this.$el.find('.details-button').text(AJS.I18n.getText('jira.mobile.more.fields.button.alt'));
                } else {
                    this.$el.find('.details-button').text(AJS.I18n.getText('jira.mobile.more.fields.button'));
                }
                this.allFieldsView.render();
            }
        });
    }
);
