define('feature/issues/issue-model', ['backbone', 'backbone-brace'], function (Backbone, Brace) {
    const Issue = Brace.Model.extend({
        namedAttributes: ['key', 'fields', 'expand', 'self', 'renderedFields', 'names', 'schema', 'editmeta', 'screen', 'permissions', 'addCommentMeta'],
        idAttribute: 'key',

        urlRoot: '/rest/mobile/1.0/issue',
        urlData: {
            expand: 'renderedFields,names,schema,editmeta,screen'
        },

        setField: function(name, value) {
            this.attributes.fields[name] = value;
            // An extra one, just for us
            this.trigger('change:fields:' + name, this);
            this.trigger('change:fields', this);
            this.trigger('change', this);
        },

        addComment: function(commentView) {
            if (!this.commentModel) {
                this.commentModel = {};
            }
            if (!this.commentModel.comments) {
                this.commentModel.comments = [];
            }
            this.commentModel.comments.push(commentView);

            this.trigger('change:comments', this);
            this.trigger('change', this);
        }
    });

    return Issue;
});
