define('feature/filters/filter-item-view', ['./filter-list.soy', 'backbone', 'util/router'], function (Templates, Backbone, router) {
    const FilterItemView = Backbone.View.extend({
        tagName: 'li',
        className: 'filter-entry',

        events: {
            'click': 'gotoFilter'
        },

        render: function () {
            this.$el.html(Templates.listEntry({
                filter: this.model.toJSON()
            }));
        },

        gotoFilter: function () {
            router.navigate('filter/' + this.model.get('id'), {trigger: true});
        }
    });

    return FilterItemView;
});
