/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.simplified.mode.service;

import com.atlassian.jira.mobile.resource.filter.CSSFilter;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.google.common.collect.Maps;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class SimplifiedModeBaseRenderer {
    private static final Logger log = LoggerFactory.getLogger(SimplifiedModeBaseRenderer.class);
    private static final String MOBILE_BASE_RESOURCE_NAME = "com.atlassian.jira.mobile:simplified-mode-base";
    private static final String MOBILE_BASE_LAYOUT_TEMPLATE_NAME = "AtlassianMobile.SimplifiedMode.Templates.JIRA.layout.frame";
    private final JiraPageBuilderService jiraPageBuilderService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public String renderTemplate(String pluginKey, String template, BaseRenderViewParams params, Map<String, Object> context) {
        String content = this.soyTemplateRenderer.render(pluginKey, template, context);
        Map<String, Object> fullContext = this.getDefaultContext();
        fullContext.put("content", content);
        fullContext.put("canonicalUrl", params.canonicalUrl);
        fullContext.put("windowTitle", params.windowTitle);
        fullContext.putAll(context);
        return this.soyTemplateRenderer.render(MOBILE_BASE_RESOURCE_NAME, MOBILE_BASE_LAYOUT_TEMPLATE_NAME, fullContext);
    }

    private Map<String, Object> getDefaultContext() {
        HashMap context = Maps.newHashMap();
        HashMap resources = Maps.newHashMap();
        this.jiraPageBuilderService.assembler().resources().requireContext("simplified-mod-general");
        WebResourceSet set = this.jiraPageBuilderService.assembler().assembled().drainIncludedResources();
        StringWriter headerResources = new StringWriter();
        set.writeHtmlTags((Writer)headerResources, UrlMode.RELATIVE, CSSFilter.PREDICATE);
        resources.put("header", headerResources.toString());
        context.put("resources", resources);
        return context;
    }

    @Autowired
    public SimplifiedModeBaseRenderer(JiraPageBuilderService jiraPageBuilderService, SoyTemplateRenderer soyTemplateRenderer) {
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    static final class BaseRenderViewParams {
        private final String windowTitle;
        private final String canonicalUrl;

        public BaseRenderViewParams(String windowTitle, String canonicalUrl) {
            this.windowTitle = windowTitle;
            this.canonicalUrl = canonicalUrl;
        }

        public String getWindowTitle() {
            return this.windowTitle;
        }

        public String getCanonicalUrl() {
            return this.canonicalUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseRenderViewParams)) {
                return false;
            }
            BaseRenderViewParams other = (BaseRenderViewParams)o;
            String this$windowTitle = this.getWindowTitle();
            String other$windowTitle = other.getWindowTitle();
            if (this$windowTitle == null ? other$windowTitle != null : !this$windowTitle.equals(other$windowTitle)) {
                return false;
            }
            String this$canonicalUrl = this.getCanonicalUrl();
            String other$canonicalUrl = other.getCanonicalUrl();
            return !(this$canonicalUrl == null ? other$canonicalUrl != null : !this$canonicalUrl.equals(other$canonicalUrl));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $windowTitle = this.getWindowTitle();
            result = result * 59 + ($windowTitle == null ? 43 : $windowTitle.hashCode());
            String $canonicalUrl = this.getCanonicalUrl();
            result = result * 59 + ($canonicalUrl == null ? 43 : $canonicalUrl.hashCode());
            return result;
        }

        public String toString() {
            return "SimplifiedModeBaseRenderer.BaseRenderViewParams(windowTitle=" + this.getWindowTitle() + ", canonicalUrl=" + this.getCanonicalUrl() + ")";
        }
    }
}

