/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.simplified.mode.service;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.mobile.simplified.mode.exceptions.JiraIssueWasNotFoundException;
import com.atlassian.jira.mobile.simplified.mode.exceptions.RendererFieldLayoutNotFoundException;
import com.atlassian.jira.mobile.simplified.mode.model.AttachmentView;
import com.atlassian.jira.mobile.simplified.mode.model.RenderedComment;
import com.atlassian.jira.mobile.simplified.mode.service.SimplifiedModeBaseRenderer;
import com.atlassian.jira.mobile.simplified.mode.service.SimplifiedModeTemplateRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class JiraIssueSimplifiedModeRenderer
implements SimplifiedModeTemplateRenderer {
    private static final Logger log = LoggerFactory.getLogger(JiraIssueSimplifiedModeRenderer.class);
    private static final Pattern ISSUE_KEY_PARSE_PATTERN = Pattern.compile("(?<=/browse/)[A-Za-z0-9-]+(?=[/?]|$)");
    private static final Pattern PATTERN = Pattern.compile("^\\/browse\\/((?:.+)-(?:.+))");
    private static final String ISSUE_TEMPLATE_NAME = "AtlassianMobile.SimplifiedMode.Templates.JIRA.Issue.drawIssue";
    private static final String ISSUE_RESOURCE_NAME = "com.atlassian.jira.mobile:view-issue-resources-simplified-mode";
    private final IssueService issueService;
    private final CommentService commentService;
    private final RendererManager rendererManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final SimplifiedModeBaseRenderer simplifiedModeBaseRenderer;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueLinkManager issueLinkManager;

    @Override
    public boolean matches(String path) {
        return PATTERN.matcher(path).matches();
    }

    @Override
    public String renderPage(HttpServletRequest request, String canonicalUrl) {
        String contextPath;
        String url = request.getRequestURI();
        String path = url.substring((contextPath = request.getContextPath()).length());
        Matcher matcher = ISSUE_KEY_PARSE_PATTERN.matcher(path);
        if (!matcher.find()) {
            throw new RuntimeException("Ticket cannot be parsed correctly.");
        }
        String issueId = matcher.group();
        return this.renderTicketPage(issueId, contextPath, canonicalUrl);
    }

    private String renderTicketPage(String issueKey, String contextPath, String canonicalUrl) {
        log.debug("Render ticket {} in simplified mode.", (Object)issueKey);
        HashMap<String, Object> context = new HashMap<String, Object>();
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        MutableIssue issue = this.issueService.getIssue(user, issueKey).getIssue();
        if (issue == null) {
            throw new JiraIssueWasNotFoundException(String.format("Issue '%s' was not found.", issueKey));
        }
        context.put("issue", issue);
        context.put("contextPath", contextPath);
        Pair<Map<String, List<IssueLink>>, Map<String, List<IssueLink>>> issueLinks = this.getIssueLinks((Issue)issue, user);
        Map groupedInwardIssueLinks = (Map)issueLinks.getLeft();
        context.put("inwardIssueLinks", groupedInwardIssueLinks);
        Map groupedOutwardIssueLinks = (Map)issueLinks.getRight();
        context.put("outwardIssueLinks", groupedOutwardIssueLinks);
        context.put("subTasks", issue.getSubTaskObjects());
        String styledDescription = this.getRenderedDescription((Issue)issue);
        context.put("styledDescription", styledDescription);
        context.put("attachments", this.getAttachments(contextPath, (Issue)issue));
        context.put("comments", this.getComments((Issue)issue));
        String pageTitle = this.getPageTitle((Issue)issue);
        SimplifiedModeBaseRenderer.BaseRenderViewParams baseRenderViewParams = new SimplifiedModeBaseRenderer.BaseRenderViewParams(pageTitle, canonicalUrl);
        return this.simplifiedModeBaseRenderer.renderTemplate(ISSUE_RESOURCE_NAME, ISSUE_TEMPLATE_NAME, baseRenderViewParams, context);
    }

    private List<AttachmentView> getAttachments(String contextPath, Issue issue) {
        return issue.getAttachments().stream().map(attachment -> new AttachmentView((Attachment)attachment, contextPath)).collect(Collectors.toList());
    }

    private Pair<Map<String, List<IssueLink>>, Map<String, List<IssueLink>>> getIssueLinks(Issue issue, ApplicationUser loggedInUser) {
        Set linkTypes;
        ArrayList outwardIssueLinks = Lists.newArrayList();
        ArrayList inwardIssueLinks = Lists.newArrayList();
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, loggedInUser);
        if (linkCollection != null && (linkTypes = linkCollection.getLinkTypes()) != null) {
            for (IssueLinkType issueLinkType : linkTypes) {
                List inwardIssues;
                List outwardIssues = linkCollection.getOutwardIssues(issueLinkType.getName());
                if (outwardIssues != null) {
                    for (Issue outwardIssue : outwardIssues) {
                        outwardIssueLinks.add(this.issueLinkManager.getIssueLink(issue.getId(), outwardIssue.getId(), issueLinkType.getId()));
                    }
                }
                if ((inwardIssues = linkCollection.getInwardIssues(issueLinkType.getName())) == null) continue;
                for (Issue inwardIssue : inwardIssues) {
                    inwardIssueLinks.add(this.issueLinkManager.getIssueLink(inwardIssue.getId(), issue.getId(), issueLinkType.getId()));
                }
            }
        }
        Map<String, List<IssueLink>> inwardMap = inwardIssueLinks.stream().collect(Collectors.groupingBy(issueLink -> issueLink.getIssueLinkType().getInward()));
        Map<String, List<IssueLink>> outwardMap = outwardIssueLinks.stream().collect(Collectors.groupingBy(issueLink -> issueLink.getIssueLinkType().getOutward()));
        return Pair.of(inwardMap, outwardMap);
    }

    private List<RenderedComment> getComments(Issue issue) {
        JiraRendererPlugin renderer = this.getIssueFieldContentRenderer(issue, "comment");
        return this.commentService.streamComments(this.jiraAuthenticationContext.getLoggedInUser(), issue).map(comment -> this.buildRenderedComment(renderer, (Comment)comment)).collect(Collectors.collectingAndThen(Collectors.toList(), results -> results.isEmpty() ? null : results));
    }

    private RenderedComment buildRenderedComment(JiraRendererPlugin renderer, Comment comment) {
        return new RenderedComment(comment, renderer.render(comment.getBody(), null));
    }

    private String getPageTitle(Issue issue) {
        Project project = issue.getProjectObject();
        return String.format("%s | %s", issue.getSummary(), project.getName());
    }

    private String getRenderedDescription(Issue issue) {
        JiraRendererPlugin renderer = this.getIssueFieldContentRenderer(issue, "description");
        return renderer.render(issue.getDescription(), null);
    }

    private JiraRendererPlugin getIssueFieldContentRenderer(Issue issue, String issueFieldId) {
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem(issueFieldId);
        if (fieldLayoutItem == null) {
            throw new RendererFieldLayoutNotFoundException(String.format("%s field cannot be retrieved of ticket '%s'", issueFieldId, issue.getKey()));
        }
        return this.rendererManager.getRendererForField(fieldLayoutItem);
    }

    @Autowired
    public JiraIssueSimplifiedModeRenderer(IssueService issueService, CommentService commentService, RendererManager rendererManager, FieldLayoutManager fieldLayoutManager, SimplifiedModeBaseRenderer simplifiedModeBaseRenderer, JiraAuthenticationContext jiraAuthenticationContext, IssueLinkManager issueLinkManager) {
        this.issueService = issueService;
        this.commentService = commentService;
        this.rendererManager = rendererManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.simplifiedModeBaseRenderer = simplifiedModeBaseRenderer;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueLinkManager = issueLinkManager;
    }
}

