/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.simplified.mode.model;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.issue.attachment.Attachment;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;

public class AttachmentView {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/YYYY hh:mm a");
    private final Attachment attachment;
    private final String contextPath;

    public String getFileSize() {
        return FileSize.format((Long)this.attachment.getFilesize());
    }

    public String getLink() {
        return String.format("%s/secure/attachment/%s/%s", this.contextPath, this.attachment.getId(), this.attachment.getFilename());
    }

    public String getFilename() {
        return this.attachment.getFilename();
    }

    public String getCreated() {
        Timestamp created = this.attachment.getCreated();
        return created.toLocalDateTime().format(DATE_TIME_FORMATTER);
    }

    public AttachmentView(Attachment attachment, String contextPath) {
        this.attachment = attachment;
        this.contextPath = contextPath;
    }
}

