/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.mobile.service.FeatureFlagService;
import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.simplified.mode.service.SimplifiedModeViewService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileRedirectFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MobileRedirectFilter.class);
    private final MobileURLTrackerService mobileURLTrackerService;
    private final FeatureFlagService featureFlagService;
    private final SimplifiedModeViewService simplifiedModeViewService;
    private String redirectPrefix;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectPrefix = filterConfig.getInitParameter("redirectPrefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain next) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        String context = request.getContextPath();
        String path = url.substring(context.length());
        if (MobileUtils.isMobileViewRequest(request)) {
            if (this.featureFlagService.isSimplifiedModeEnabled()) {
                log.debug("Simplified mode enabled. Render simple view of page.");
                boolean rendered = this.simplifiedModeViewService.renderSimpleView(request, response);
                if (rendered) {
                    return;
                }
                log.debug("Skip simplified rendering of the view, because renderer wasn't found.");
            } else {
                String fragment = this.mobileURLTrackerService.mapPath(path, request);
                if (fragment != null) {
                    String redirectUrl = String.format("%s%s#%s", context, this.redirectPrefix, fragment);
                    if (!response.isCommitted()) {
                        response.sendRedirect(redirectUrl);
                        return;
                    }
                    log.warn("We wanted to redirect to the JIRA Mobile page '{}', but the HTTP response is already committed to, so we can't.", (Object)redirectUrl);
                    if (log.isDebugEnabled()) {
                        String requestURL = request.getRequestURL().toString();
                        String responseLocation = response.getHeader("location");
                        log.debug("Requested URL: '{}', Response location header: '{}'", (Object)requestURL, (Object)responseLocation);
                    }
                }
            }
        }
        next.doFilter(servletRequest, servletResponse);
    }

    public MobileRedirectFilter(MobileURLTrackerService mobileURLTrackerService, FeatureFlagService featureFlagService, SimplifiedModeViewService simplifiedModeViewService) {
        this.mobileURLTrackerService = mobileURLTrackerService;
        this.featureFlagService = featureFlagService;
        this.simplifiedModeViewService = simplifiedModeViewService;
    }
}

