/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.mobile.auth.ApplicationUserProvider;
import com.atlassian.jira.mobile.auth.AuthUrlProvider;
import com.atlassian.jira.mobile.service.FeatureFlagService;
import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import com.atlassian.jira.user.ApplicationUser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileAuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MobileAuthenticationFilter.class);
    private final AuthUrlProvider authUrlProvider;
    private final ApplicationUserProvider userProvider;
    private final MobileURLTrackerService mobileURLTrackerService;
    private final FeatureFlagService featureFlagService;
    private String redirectPrefix;
    private static final String JIRA_INTERNAL_LOGIN_URL = "/login.jsp";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectPrefix = filterConfig.getInitParameter("redirectPrefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String fragment;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ApplicationUser user = this.userProvider.getRemoteUser(request);
        String context = request.getContextPath();
        String destinationPath = this.getDestinationPath(context, request);
        if (MobileUtils.isMobileViewRequest(request) && this.mobileURLTrackerService.requiresLogin(destinationPath, request, user) && !this.isInternalLoginPage(destinationPath) && StringUtils.isNotBlank((String)(fragment = this.getMobileDestination(destinationPath, request)))) {
            String loginPageRedirectUrl = this.getLoginPageRedirectUrl(fragment, destinationPath, request);
            if (log.isDebugEnabled()) {
                log.debug("Redirecting request for mobile page to the login URL '{}'", (Object)loginPageRedirectUrl);
            }
            response.sendRedirect(loginPageRedirectUrl);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String getDestinationPath(String context, HttpServletRequest request) {
        String path = request.getParameter("os_destination");
        if (StringUtils.isBlank((String)path)) {
            String url = request.getRequestURI();
            path = url.substring(context.length());
        }
        return path;
    }

    private String getMobileDestination(String destinationPath, HttpServletRequest request) {
        return this.mobileURLTrackerService.mapPath(destinationPath, request);
    }

    private boolean isInternalLoginPage(String destinationPath) {
        return destinationPath.startsWith(JIRA_INTERNAL_LOGIN_URL);
    }

    private String getLoginPageRedirectUrl(String fragment, String originalPath, HttpServletRequest request) throws UnsupportedEncodingException {
        String redirectPath = String.format("%s#%s", this.redirectPrefix, fragment);
        if (this.featureFlagService.isSimplifiedModeEnabled()) {
            redirectPath = originalPath;
        }
        return this.authUrlProvider.getLoginUrl(redirectPath, request);
    }

    public MobileAuthenticationFilter(AuthUrlProvider authUrlProvider, ApplicationUserProvider userProvider, MobileURLTrackerService mobileURLTrackerService, FeatureFlagService featureFlagService) {
        this.authUrlProvider = authUrlProvider;
        this.userProvider = userProvider;
        this.mobileURLTrackerService = mobileURLTrackerService;
        this.featureFlagService = featureFlagService;
    }
}

