define('feature/issue-lists/issue-list-item-view', ['backbone', 'util/router'], function (Backbone, router) {
    var IssueListItemView = Backbone.View.extend({
        tagName: 'li',
        className: 'issue-entry',

        events: {
            'click': 'gotoIssue'
        },

        render: function () {
            this.$el.html(AtlassianMobile.Templates.JIRA.IssueList.listEntry({
                issue: this.model.toJSON()
            }));
        },

        gotoIssue: function () {
            router.navigate('issue/' + this.model.get('key'), {trigger: true});
        }
    });

    return IssueListItemView;
});