define('feature/filters/favourites',
    ['zepto', 'util/auth', 'feature/filters/filter-collection'],
    function ($, auth, FilterList) {
        var favourites = {
            collection: new FilterList(),
            $el: $('#side-nav-filters'),
            deferred: $.Deferred(),

            init: function () {
                favourites.deferred = $.Deferred();
                favourites.deferred.then(favourites.updateSidebar);
                favourites.fetch(favourites.deferred.resolve);
            },

            get: function (callback) {
                favourites.deferred.done(callback);
            },

            fetch: function (callback) {
                favourites.collection.fetch({
                    success: callback
                });
            },

            reset: function () {
                favourites.deferred = $.Deferred();
                favourites.collection.reset();
                favourites.updateSidebar();
            },

            updateSidebar: function () {
                favourites.$el.find('li.favourite-filter').remove();
                var links = [];
                if (favourites.collection.length) {
                    links.push(favourites.createMenuItem('#filters/favourite', AJS.I18n.getText('jira.mobile.filters.view.favourite')));
                }
                if (links.length) {
                    favourites.$el.append.apply(favourites.$el, links);
                }
            },

            createMenuItem: function (href, text) {
                var $li = $('<li class="favourite-filter"/>');
                var $a = $('<a/>').attr('href', href).text(text);
                $li.append($a);
                return $li;
            }
        };

        auth.on('login', favourites.init);
        auth.on('logout', favourites.reset);

        return favourites;
    }
);