// Generated by CoffeeScript 1.3.1

/*
Simply Deferred - v.1.2.1
http://sudhirj.github.com/simply-deferred/
(c) 2012 Sudhir Jonathan, contact.me@sudhirjonathan.com, MIT Licensed.
Portions of this code are inspired and borrowed from Underscore.js (http://underscorejs.org/) (MIT License)
*/


(function() {
  var Deferred, PENDING, REJECTED, RESOLVED, after, execute, flatten, has, installInto, isArguments, wrap, _when,
    __slice = [].slice;

  PENDING = "pending";

  RESOLVED = "resolved";

  REJECTED = "rejected";

  has = function(obj, prop) {
    return obj != null ? obj.hasOwnProperty(prop) : void 0;
  };

  isArguments = function(obj) {
    return has(obj, 'length') && has(obj, 'callee');
  };

  flatten = function(array) {
    if (isArguments(array)) {
      return flatten(Array.prototype.slice.call(array));
    }
    if (!Array.isArray(array)) {
      return [array];
    }
    return array.reduce(function(memo, value) {
      if (Array.isArray(value)) {
        return memo.concat(flatten(value));
      }
      memo.push(value);
      return memo;
    }, []);
  };

  after = function(times, func) {
    if (times <= 0) {
      return func();
    }
    return function() {
      if (--times < 1) {
        return func.apply(this, arguments);
      }
    };
  };

  wrap = function(func, wrapper) {
    return function() {
      var args;
      args = [func].concat(Array.prototype.slice.call(arguments, 0));
      return wrapper.apply(this, args);
    };
  };

  execute = function(callbacks, args) {
    var callback, _i, _len, _ref, _results;
    _ref = flatten(callbacks);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      callback = _ref[_i];
      _results.push(callback.apply(null, args));
    }
    return _results;
  };

  Deferred = function() {
    var alwaysCallbacks, close, closingArguments, doneCallbacks, failCallbacks, state;
    state = PENDING;
    doneCallbacks = [];
    failCallbacks = [];
    alwaysCallbacks = [];
    closingArguments = {};
    this.promise = function(candidate) {
      var pipe, storeCallbacks;
      candidate = candidate || {};
      candidate.state = function() {
        return state;
      };
      /**
       * ATLASSIAN PATCH
       *
       * Add some convenience functions to stop Atlassian Analytics throwing a script error.
       * AA relies on .isResolved() and .isRejected(), but these are deprecated in jQuery 1.7
       * and not supported by Simply Deferred
       */
      candidate.isResolved = function () {
        return state == RESOLVED;
      }
      candidate.isRejected = function () {
        return state == REJECTED;
      }
      // END ATLASSIAN PATCH
      storeCallbacks = function(shouldExecuteImmediately, holder) {
        return function() {
          if (state === PENDING) {
            holder.push.apply(holder, flatten(arguments));
          }
          if (shouldExecuteImmediately()) {
            execute(arguments, closingArguments);
          }
          return candidate;
        };
      };
      pipe = function(doneFilter, failFilter) {
        var deferred, filter;
        deferred = new Deferred();
        filter = function(target, source, filter) {
          if (filter) {
            return target(function() {
              return source(filter.apply(null, flatten(arguments)));
            });
          } else {
            return target(function() {
              return source.apply(null, flatten(arguments));
            });
          }
        };
        filter(candidate.done, deferred.resolve, doneFilter);
        filter(candidate.fail, deferred.reject, failFilter);
        return deferred;
      };
      candidate.done = storeCallbacks((function() {
        return state === RESOLVED;
      }), doneCallbacks);
      candidate.fail = storeCallbacks((function() {
        return state === REJECTED;
      }), failCallbacks);
      candidate.always = storeCallbacks((function() {
        return state !== PENDING;
      }), alwaysCallbacks);
      candidate.pipe = pipe;
      candidate.then = pipe;
      return candidate;
    };
    this.promise(this);
    close = function(finalState, callbacks) {
      return function() {
        if (state === PENDING) {
          state = finalState;
          closingArguments = arguments;
          execute([callbacks, alwaysCallbacks], closingArguments);
        }
        return this;
      };
    };
    this.resolve = close(RESOLVED, doneCallbacks);
    this.reject = close(REJECTED, failCallbacks);
    return this;
  };

  _when = function() {
    var def, defs, finish, trigger, _i, _j, _len, _len1;
    trigger = new Deferred();
    defs = flatten(arguments);
    finish = after(defs.length, trigger.resolve);
    for (_i = 0, _len = defs.length; _i < _len; _i++) {
      def = defs[_i];
      def.done(finish);
    }
    for (_j = 0, _len1 = defs.length; _j < _len1; _j++) {
      def = defs[_j];
      def.fail(function() {
        return trigger.reject();
      });
    }
    return trigger.promise();
  };

  installInto = function(fw) {
    fw.Deferred = function() {
      return new Deferred();
    };
    fw.ajax = wrap(fw.ajax, function(ajax, options) {
      var createWrapper, def;
      if (options == null) {
        options = {};
      }
      def = new Deferred();
      createWrapper = function(wrapped, finisher) {
        return wrap(wrapped, function() {
          var args, func;
          func = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
          if (func) {
            func.apply(null, args);
          }
          return finisher.apply(null, args);
        });
      };
      options.success = createWrapper(options.success, def.resolve);
      options.error = createWrapper(options.error, def.reject);

      /**
       * ATLASSIAN PATCH
       *
       * Allow access to the original XHR to be able to call methods like abort()
       */
      var xhr = ajax(options);
      var promise = def.promise();
      promise.origXHR = xhr;
      promise.abort = function () {
        xhr.abort();
      };

      // Make sure callbacks added through .done() etc. are delayed to match the changes in ajax.js
      _.each(['done', 'fail', 'always'], function (name) {
        var _method = promise[name];
        promise[name] = function () {
          var context = this;
          var args = arguments;
          var fn = function () {
            _.defer(function () {
              _method.apply(context, args);
            })
          };
          _method.call(context, fn);
        }
      });
      return promise;
      // END ATLASSIAN PATCH

      /**
       * Original code
      ajax(options);
      return def.promise();
       */
    });
    return fw.when = _when;
  };

  if (typeof exports !== 'undefined') {
    exports.Deferred = function() {
      return new Deferred();
    };
    exports.when = _when;
    exports.installInto = installInto;
  } else {
    this.Deferred = function() {
      return new Deferred();
    };
    this.Deferred.when = _when;
    this.Deferred.installInto = installInto;
  }

}).call(this);