/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.mobile.compat.lasso.LassoPluginAccessor;
import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class MobileAuthenticationFilter
implements Filter {
    private final UserManager userManager;
    private final MobileURLTrackerService mobileURLTrackerService;
    private final LassoPluginAccessor lassoPluginAccessor;
    private String redirectPrefix;
    private static final String LOGIN_URL = "/login.jsp";

    public MobileAuthenticationFilter(UserManager userManager, MobileURLTrackerService mobileURLTrackerService, LassoPluginAccessor lassoPluginAccessor) {
        this.userManager = userManager;
        this.mobileURLTrackerService = mobileURLTrackerService;
        this.lassoPluginAccessor = lassoPluginAccessor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectPrefix = filterConfig.getInitParameter("redirectPrefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String fragment;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String loggedInUsername = this.userManager.getRemoteUsername(request);
        String context = request.getContextPath();
        if (MobileUtils.isMobileViewRequest(request) && this.mobileURLTrackerService.requiresLogin(this.getDestinationPath(context, request), request, loggedInUsername) && StringUtils.isNotBlank((String)(fragment = this.getMobileDestination(context, request)))) {
            Boolean isOnDemand = ((FeatureManager)ComponentAccessor.getComponent(FeatureManager.class)).isEnabled(CoreFeatures.ON_DEMAND);
            if (isOnDemand.booleanValue()) {
                response.sendRedirect(this.getOndemandRedirectPath(context, fragment));
            } else if (this.isLassoEnabled()) {
                if (this.isLoginPage(context, request)) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                response.sendRedirect(this.getLassoRedirectPath(context, fragment));
            } else {
                response.sendRedirect(this.getBTFRedirectPath(context, fragment));
            }
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String getDestinationPath(String context, HttpServletRequest request) {
        String path = request.getParameter("os_destination");
        if (StringUtils.isBlank((String)path)) {
            String url = request.getRequestURI();
            path = url.substring(context.length());
        }
        return path;
    }

    private boolean isLassoEnabled() {
        return this.lassoPluginAccessor.isLassoEnabled();
    }

    private String getMobileDestination(String context, HttpServletRequest request) {
        String path = this.getDestinationPath(context, request);
        String fragment = this.mobileURLTrackerService.mapPath(path, request);
        return fragment;
    }

    private boolean isLoginPage(String context, HttpServletRequest request) {
        String path = this.getDestinationPath(context, request);
        return path.startsWith(LOGIN_URL);
    }

    private String getLassoRedirectPath(String context, String fragment) throws UnsupportedEncodingException {
        String redirectUrl = String.format("%s#%s", this.redirectPrefix, fragment);
        StringBuilder sb = new StringBuilder();
        sb.append(context).append("/login.jspa?os_destination=").append(URLEncoder.encode(redirectUrl, "UTF-8"));
        return sb.toString();
    }

    private String getOndemandRedirectPath(String context, String fragment) throws UnsupportedEncodingException {
        String redirectUrl = String.format("%s#%s", this.redirectPrefix, fragment);
        StringBuilder sb = new StringBuilder();
        sb.append(context).append("/login?dest-url=").append(URLEncoder.encode(redirectUrl, "UTF-8"));
        return sb.toString();
    }

    private String getBTFRedirectPath(String context, String fragment) {
        String redirectUrl = String.format("%s%s#%s%s", context, this.redirectPrefix, "login/", fragment);
        return redirectUrl;
    }
}

