/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.validation;

import com.atlassian.fugue.Either;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.webhooks.api.util.ErrorMessage;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.google.common.base.Optional;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JqlValidationUtil {
    private final JqlQueryParser jqlQueryParser;
    private final I18nResolver i18n;

    @Autowired
    public JqlValidationUtil(JqlQueryParser jqlQueryParser, I18nResolver i18n) {
        this.jqlQueryParser = jqlQueryParser;
        this.i18n = i18n;
    }

    public void validateFilter(MessageCollection.Builder errorCollectionBuilder, Optional<String> filter) {
        String jql;
        Either<JqlParseException, String> jqlValid;
        if (filter.isPresent() && StringUtils.isNotBlank((String)((String)filter.get())) && !(jqlValid = this.isJqlValid(jql = (String)filter.get())).isRight()) {
            ErrorMessage errorMessage = new ErrorMessage("jql", new Serializable[]{this.i18n.getText("webhooks.invalid.jql", new Serializable[]{jql, (Serializable)jqlValid.left().get()})});
            errorCollectionBuilder.addMessage((Message)errorMessage, MessageCollection.Reason.VALIDATION_FAILED);
        }
    }

    public Either<JqlParseException, String> isJqlValid(String jql) {
        try {
            this.jqlQueryParser.parseQuery(jql);
            return Either.right((Object)jql);
        }
        catch (JqlParseException e) {
            return Either.left((Object)((Object)e));
        }
    }
}

