/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.validation;

import com.atlassian.jira.plugins.webhooks.listener.JqlFilterStoreUtils;
import com.atlassian.jira.plugins.webhooks.validation.JqlValidationUtil;
import com.atlassian.jira.plugins.webhooks.workflow.WorkflowUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.util.ErrorMessage;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.spi.WebHookListenerActionValidator;
import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraWebHookListenerActionValidator
implements WebHookListenerActionValidator {
    private final JqlValidationUtil jqlValidationUtil;
    private final I18nResolver i18n;
    private final WorkflowUtil workflowUtil;

    @Autowired
    public JiraWebHookListenerActionValidator(JqlValidationUtil jqlValidationUtil, I18nResolver i18n, WorkflowUtil workflowUtil) {
        this.jqlValidationUtil = jqlValidationUtil;
        this.i18n = i18n;
        this.workflowUtil = workflowUtil;
    }

    public MessageCollection validateWebHookRegistration(PersistentWebHookListener listener) {
        return this.validateAdditionAndUpdate(listener);
    }

    public MessageCollection validateWebHookUpdate(PersistentWebHookListener listener) {
        return this.validateAdditionAndUpdate(listener);
    }

    private MessageCollection validateAdditionAndUpdate(PersistentWebHookListener listener) {
        MessageCollection.Builder builder = MessageCollection.builder();
        Optional filter = Optional.fromNullable((Object)JqlFilterStoreUtils.getJqlFilter(listener));
        this.jqlValidationUtil.validateFilter(builder, (Optional<String>)filter);
        return builder.build();
    }

    public MessageCollection validateWebHookRemoval(PersistentWebHookListener webHookListenerParameters) {
        Set<Map<String, String>> transitions = this.workflowUtil.getTransitionLinkedToWebHookListener((Integer)webHookListenerParameters.getId().get());
        if (!transitions.isEmpty()) {
            MessageCollection.Builder errorCollectionBuilder = MessageCollection.builder();
            ErrorMessage conflictErrorMsg = new ErrorMessage("title", new Serializable[]{this.i18n.getText("webhooks.delete.error.linkedtransitions", new Serializable[]{webHookListenerParameters.getName()})});
            ErrorMessage transitionsErrorMsg = new ErrorMessage("transitions", new Serializable[]{transitions.toString()});
            errorCollectionBuilder.addMessage((Message)conflictErrorMsg, MessageCollection.Reason.CONFLICT);
            errorCollectionBuilder.addMessage((Message)transitionsErrorMsg, MessageCollection.Reason.CONFLICT);
            return errorCollectionBuilder.build();
        }
        return MessageCollection.empty();
    }
}

