/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.registration;

import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.event.issue.link.IssueLinkDeletedEvent;
import com.atlassian.jira.event.project.VersionCreateEvent;
import com.atlassian.jira.event.project.VersionDeleteEvent;
import com.atlassian.jira.event.project.VersionMergeEvent;
import com.atlassian.jira.event.project.VersionMoveEvent;
import com.atlassian.jira.event.project.VersionReleaseEvent;
import com.atlassian.jira.event.project.VersionUnreleaseEvent;
import com.atlassian.jira.event.project.VersionUpdatedEvent;
import com.atlassian.jira.event.property.AbstractApplicationPropertySetEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.worklog.WorklogCreatedEvent;
import com.atlassian.jira.event.worklog.WorklogDeletedEvent;
import com.atlassian.jira.event.worklog.WorklogUpdatedEvent;
import com.atlassian.jira.plugins.webhooks.matcher.ApplicationPropertyEventMatcher;
import com.atlassian.jira.plugins.webhooks.matcher.EventTypeMatcher;
import com.atlassian.jira.plugins.webhooks.matcher.IssueEventIdMatcher;
import com.atlassian.jira.plugins.webhooks.matcher.JqlEventMatcher;
import com.atlassian.jira.plugins.webhooks.matcher.UniversalJqlEventMatcher;
import com.atlassian.jira.plugins.webhooks.ui.JiraJQLPanel;
import com.atlassian.jira.plugins.webhooks.workflow.WebHookPostFunctionEvent;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.util.EventMatchers;
import com.atlassian.webhooks.spi.EventMatcher;
import com.atlassian.webhooks.spi.WebHooksHtmlPanel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RegisteredWebHookEventFactory {
    private final Iterable<RegisteredWebHookEvent> allEvents;
    private final Iterable<WebHookEventSection> webHookEventSections;
    private final JqlEventMatcher jqlEventMatcher;

    @Autowired
    public RegisteredWebHookEventFactory(JiraJQLPanel jiraJQLPanel, JqlEventMatcher jqlEventMatcher) {
        this.jqlEventMatcher = jqlEventMatcher;
        WebHookEventGroup issueGroup = WebHookEventGroup.builder().nameI18nKey("webhook.group.issue").addEvent(this.jqlFilterableIssueRelatedEvent("jira:issue_created", "webhook.group.issue.created", IssueEvent.class, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_CREATED_ID}))).addEvent(this.jqlFilterableIssueRelatedEvent("jira:issue_updated", "webhook.group.issue.updated", IssueEvent.class, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_ASSIGNED_ID, EventType.ISSUE_CLOSED_ID, EventType.ISSUE_REOPENED_ID, EventType.ISSUE_RESOLVED_ID, EventType.ISSUE_COMMENT_EDITED_ID, EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_MOVED_ID, EventType.ISSUE_UPDATED_ID, EventType.ISSUE_WORKSTARTED_ID, EventType.ISSUE_WORKSTOPPED_ID, EventType.ISSUE_GENERICEVENT_ID, EventType.ISSUE_COMMENT_DELETED_ID}))).addEvent(this.jqlFilterableIssueRelatedEvent("jira:issue_deleted", "webhook.group.issue.deleted", IssuePreDeleteEvent.class, Collections.emptySet())).addEvent(this.jqlFilterableIssueRelatedEvent("jira:worklog_updated", "webhook.group.issue.worklog.changed", IssueEvent.class, Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_WORKLOG_UPDATED_ID, EventType.ISSUE_WORKLOG_DELETED_ID, EventType.ISSUE_WORKLOGGED_ID}))).build();
        UniversalJqlEventMatcher commentEventMatcher = new UniversalJqlEventMatcher(jqlEventMatcher, event -> event.getComment().getIssue());
        WebHookEventGroup commentGroup = WebHookEventGroup.builder().nameI18nKey("webhook.group.comment").addEvent(this.eventWithMatcher("comment_created", "webhook.group.comment.created", CommentCreatedEvent.class, commentEventMatcher)).addEvent(this.eventWithMatcher("comment_updated", "webhook.group.comment.updated", CommentUpdatedEvent.class, commentEventMatcher)).addEvent(this.eventWithMatcher("comment_deleted", "webhook.group.comment.deleted", CommentDeletedEvent.class, commentEventMatcher)).build();
        WebHookEventGroup issueLinkGroup = WebHookEventGroup.builder().nameI18nKey("webhook.group.issue-link").addEvent(this.eventWithoutFiltering("issuelink_created", "webhook.group.issue-link.created", IssueLinkCreatedEvent.class)).addEvent(this.eventWithoutFiltering("issuelink_deleted", "webhook.group.issue-link.removed", IssueLinkDeletedEvent.class)).build();
        UniversalJqlEventMatcher worklogEventMatcher = new UniversalJqlEventMatcher(jqlEventMatcher, event -> event.getWorklog().getIssue());
        WebHookEventGroup worklogGroup = WebHookEventGroup.builder().nameI18nKey("webhook.group.worklog").addEvent(this.eventWithMatcher("worklog_created", "webhook.group.worklog.created", WorklogCreatedEvent.class, worklogEventMatcher)).addEvent(this.eventWithMatcher("worklog_updated", "webhook.group.worklog.updated", WorklogUpdatedEvent.class, worklogEventMatcher)).addEvent(this.eventWithMatcher("worklog_deleted", "webhook.group.worklog.deleted", WorklogDeletedEvent.class, worklogEventMatcher)).build();
        WebHookEventGroup versionGroup = WebHookEventGroup.builder().nameI18nKey("webhook.group.version").addEvent(this.eventWithoutFiltering("jira:version_released", "webhook.group.version.released", VersionReleaseEvent.class)).addEvent(this.eventWithoutFiltering("jira:version_unreleased", "webhook.group.version.unreleased", VersionUnreleaseEvent.class)).addEvent(this.eventWithoutFiltering("jira:version_created", "webhook.group.version.created", VersionCreateEvent.class)).addEvent(this.eventWithoutFiltering("jira:version_moved", "webhook.group.version.moved", VersionMoveEvent.class)).addEvent(this.eventWithoutFiltering("jira:version_updated", "webhook.group.version.updated", VersionUpdatedEvent.class)).addEvent(this.eventWithoutFiltering("jira:version_merged", "webhook.group.version.merged", VersionMergeEvent.class)).addEvent(this.eventWithoutFiltering("jira:version_deleted", "webhook.group.version.deleted", VersionDeleteEvent.class)).build();
        WebHookEventGroup projectGroup = WebHookEventGroup.builder().nameI18nKey("webhook.group.project").addEvent(this.eventWithoutFiltering("project_created", "webhook.group.project.created", ProjectCreatedEvent.class)).addEvent(this.eventWithoutFiltering("project_updated", "webhook.group.project.updated", ProjectUpdatedEvent.class)).addEvent(this.eventWithoutFiltering("project_deleted", "webhook.group.project.deleted", ProjectDeletedEvent.class)).build();
        WebHookEventGroup systemWebHooksGroup = WebHookEventGroup.builder().addEvent(RegisteredWebHookEvent.withId((String)"jira-webhook-post-function").firedWhen(WebHookPostFunctionEvent.class).isMatchedBy((EventMatcher)new WebHookPostFunctionEvent.FunctionEventIdMatcher())).build();
        WebHookEventSection issueRelatedSection = WebHookEventSection.section((String)"issue-related-events-section").nameI18nKey("webhook.section.issue-related").descriptionI18nKey("webhook.section.issue-related.description").addGroup(issueGroup).addGroup(worklogGroup).addGroup(commentGroup).addGroup(issueLinkGroup).panel((WebHooksHtmlPanel)jiraJQLPanel).build();
        WebHookEventSection projectSection = WebHookEventSection.section((String)"project-related-events-section").nameI18nKey("webhook.section.project-related").descriptionI18nKey("webhook.section.project-related.description").addGroup(projectGroup).addGroup(versionGroup).build();
        WebHookEventSection userSection = WebHookEventSection.section((String)"user-related-events-section").nameI18nKey("webhook.section.user-related").addGroup(WebHookEventGroup.builder().nameI18nKey("webhook.group.user").addEvent(this.eventWithoutFiltering("user_created", "webhook.group.user.created", UserCreatedEvent.class)).addEvent(this.eventWithoutFiltering("user_deleted", "webhook.group.user.deleted", UserDeletedEvent.class)).addEvent(this.eventWithMatcher("user_updated", "webhook.group.user.updated", UserUpdatedEvent.class, EventTypeMatcher.narrowToSubclasses(UserEditedEvent.class, AutoUserUpdatedEvent.class))).build()).build();
        WebHookEventSection propertiesSection = WebHookEventSection.section((String)"application-property-section").nameI18nKey("webhook.section.application-properties").addGroup(WebHookEventGroup.builder().nameI18nKey("webhook.jira.features.status").addEvent(this.applicationPropertyEvent("option_voting_changed", "webhook.voting.option.changed", "jira.option.voting")).addEvent(this.applicationPropertyEvent("option_watching_changed", "webhook.watching.option.changed", "jira.option.watching")).addEvent(this.applicationPropertyEvent("option_unassigned_issues_changed", "webhook.unassigned.issues.option.changed", "jira.option.allowunassigned")).addEvent(this.applicationPropertyEvent("option_subtasks_changed", "webhook.subtasks.option.changed", "jira.option.allowsubtasks")).addEvent(this.applicationPropertyEvent("option_attachments_changed", "webhook.attachments.option.changed", "jira.option.allowattachments")).addEvent(this.applicationPropertyEvent("option_issuelinks_changed", "webhook.issuelinks.option.changed", "jira.option.issuelinking")).addEvent(this.applicationPropertyEvent("option_timetracking_changed", "webhook.timetracking.option.changed", "jira.option.timetracking")).build()).build();
        WebHookEventSection systemSection = WebHookEventSection.section((String)"system-section").addGroup(systemWebHooksGroup).build();
        this.webHookEventSections = ImmutableList.builder().add((Object)issueRelatedSection).add((Object)projectSection).add((Object)userSection).add((Object)propertiesSection).add((Object)systemSection).build();
        Iterable groups = Iterables.concat((Iterable)Iterables.transform(this.webHookEventSections, (Function)new Function<WebHookEventSection, Set<WebHookEventGroup>>(){

            public Set<WebHookEventGroup> apply(WebHookEventSection webHookEventSection) {
                return webHookEventSection.getGroups();
            }
        }));
        this.allEvents = Iterables.concat((Iterable)Iterables.transform((Iterable)groups, (Function)new Function<WebHookEventGroup, Iterable<RegisteredWebHookEvent>>(){

            public Iterable<RegisteredWebHookEvent> apply(WebHookEventGroup group) {
                return group.getEvents();
            }
        }));
    }

    public Iterable<RegisteredWebHookEvent> getAllEvents() {
        return this.allEvents;
    }

    public Iterable<WebHookEventSection> getWebHookEventSections() {
        return this.webHookEventSections;
    }

    private <T extends IssueRelatedEvent> RegisteredWebHookEvent jqlFilterableIssueRelatedEvent(String id, String namei18nKey, Class<T> eventClass, Set<Long> issueEventIds) {
        return RegisteredWebHookEvent.withId((String)id).andDisplayName(namei18nKey).firedWhen(eventClass).isMatchedBy((EventMatcher)(!issueEventIds.isEmpty() ? EventMatchers.and((EventMatcher[])new EventMatcher[]{new IssueEventIdMatcher(issueEventIds), this.jqlEventMatcher}) : this.jqlEventMatcher));
    }

    private RegisteredWebHookEvent eventWithoutFiltering(String id, String namei18nKey, Class<?> eventClass) {
        return RegisteredWebHookEvent.withId((String)id).andDisplayName(namei18nKey).firedWhen(eventClass).isMatchedBy(EventMatchers.ALWAYS_TRUE);
    }

    private <T> RegisteredWebHookEvent eventWithMatcher(String id, String displayName, Class<T> eventClass, EventMatcher<? super T> matcher) {
        return RegisteredWebHookEvent.withId((String)id).andDisplayName(displayName).firedWhen(eventClass).isMatchedBy(matcher);
    }

    private RegisteredWebHookEvent applicationPropertyEvent(String id, String displayName, String key) {
        return RegisteredWebHookEvent.withId((String)id).andDisplayName(displayName).firedWhen(AbstractApplicationPropertySetEvent.class).isMatchedBy((EventMatcher)new ApplicationPropertyEventMatcher(key));
    }
}

