/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.matcher;

import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.spi.EventMatcher;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EventTypeMatcher<T>
implements EventMatcher<T> {
    private final Set<Class<? extends T>> acceptedEvents;

    private EventTypeMatcher(Iterable<Class<? extends T>> acceptedEvents) {
        this.acceptedEvents = ImmutableSet.copyOf(acceptedEvents);
    }

    public static <T> EventTypeMatcher<T> narrowToSubclasses(Class<? extends T> ... acceptedEvents) {
        return new EventTypeMatcher<T>(Lists.newArrayList((Object[])acceptedEvents));
    }

    public boolean matches(T event, WebHookListener listener) {
        for (Class<T> eventClass : this.acceptedEvents) {
            if (!eventClass.isInstance(event)) continue;
            return true;
        }
        return false;
    }
}

