define('jira-webhooks/entities/transition-model', ['jira/backbone-1.4'], function (Backbone) {
  'use strict';

  return Backbone.Model.extend({});
});
define('jira-webhooks/entities/transition-collection', ['jira-webhooks/entities/transition-model', 'wrm/context-path', 'jira/backbone-1.4'], function (TransitionModel, wrmContextPath, Backbone) {
  'use strict';

  var contextPath = wrmContextPath();
  return Backbone.Collection.extend({
    initialize: function initialize(options) {
      this.selectionModel = options.selectionModel;
    },
    url: function url() {
      var webhookId = this.selectionModel.getSelected().get("id");
      return contextPath + "/rest/jira-webhook/1.0/webhooks/" + webhookId + "/transitions";
    },
    model: TransitionModel
  });
});
define('jira-webhooks/entities/transition-item-view', ['jira/util/formatter', 'jira/util/strings', 'wrm/context-path', 'jira/backbone-1.4', 'jquery'], function (formatter, strings, wrmContextPath, Backbone, $) {
  'use strict';

  var contextPath = wrmContextPath();
  return Backbone.View.extend({
    tagName: 'li',
    render: function render() {
      var unescapedWorkflowName = this.model.get("workflow");
      var workflowName = strings.escapeHtml(unescapedWorkflowName);
      var transitionName = strings.escapeHtml(this.model.get("transition"));
      var workflowLink = $("<a></a>").attr("href", contextPath + "/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=live&workflowName=" + unescapedWorkflowName).html(workflowName).wrap("<div></div>").parent().html();
      this.$el.append(formatter.I18n.getText("webhooks.transition", transitionName, workflowLink));
    }
  });
});
define('jira-webhooks/entities/transitions-view', ['jira-webhooks/entities/transition-item-view', 'jira/util/formatter', 'jira/backbone-1.4', 'jquery'], function (TransitionView, formatter, Backbone, $) {
  'use strict';

  return Backbone.View.extend({
    el: "#webhook-transitions",
    initialize: function initialize() {
      this.model.selectionModel.onSelectionChange(this.selectionChanged, this);
      /**
       * This method gets executed from jira-webhooks-admin-init.js - after DCL + resolving required resources.
       * The webhooks-admin.js (atlassian-webhooks) also uses DCL to init + it fetches model data from Jira rest endpoint and triggers selectionChanged event.
       * Sometimes the selectionChanged event is triggered before this method gets executed (and binds this.selectionChanged handler) -
       * result of this path of execution is that we don't fetch the transitions data from rest endpoint.
       * The code below ensures that we always fetch the data.
       */
      if (this.model.selectionModel.getSelected()) {
        this._fetchModel();
      }
    },
    render: function render() {
      var _this = this;
      this.$el.empty();
      if (this.model.length === 0) {
        var noTransitionsMessage = $("<span></span>").text(formatter.I18n.getText("webhooks.transitions.notransitions"));
        this.$el.append(noTransitionsMessage);
      }
      this.model.each(function (model) {
        var transitionView = new TransitionView({
          model: model
        });
        transitionView.render();
        _this.$el.append(transitionView.$el);
      });
    },
    selectionChanged: function selectionChanged(selectionModel, selectedModel) {
      if (selectedModel && typeof selectedModel.get("id") !== "undefined") {
        this._fetchModel();
      } else {
        this.model.reset();
        this.render();
      }
    },
    _fetchModel: function _fetchModel() {
      var _this2 = this;
      this.model.fetch({
        success: function success() {
          return _this2.render();
        }
      });
    }
  });
});