/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.plugins.webhooks.jql.JqlIssueMatcher;
import com.atlassian.jira.plugins.webhooks.workflow.TransitionMapper;
import com.atlassian.jira.plugins.webhooks.workflow.WebHookPostFunctionEvent;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookService;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;

public class TriggerWebhookFunction
extends AbstractJiraFunctionProvider {
    private static final Logger LOG = Logger.getLogger(TriggerWebhookFunction.class);
    private final I18nResolver i18n;
    private final TransitionMapper transitionMapper;
    private final EventPublisher eventPublisher;
    private final JqlIssueMatcher jqlIssueMatcher;
    private final WebhookService webHookService;

    public TriggerWebhookFunction(I18nResolver i18n, TransitionMapper transitionMapper, EventPublisher eventPublisher, JqlIssueMatcher jqlIssueMatcher, WebhookService webHookService) {
        this.i18n = i18n;
        this.transitionMapper = transitionMapper;
        this.eventPublisher = eventPublisher;
        this.jqlIssueMatcher = jqlIssueMatcher;
        this.webHookService = webHookService;
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String webHookId = (String)args.get("field.webhookId");
        Optional webHookOption = this.webHookService.findById(Integer.parseInt(webHookId));
        if (!webHookOption.isPresent()) {
            LOG.error((Object)this.i18n.getText("webhooks.postfunction.deleted"));
            return;
        }
        Webhook webHook = (Webhook)webHookOption.get();
        MutableIssue issue = this.getIssue(transientVars);
        if (issue == null || !issue.isCreated()) {
            LOG.error((Object)"Transition cannot be sent to webhook as an issue has not been created yet.");
            return;
        }
        String jql = (String)webHook.getConfiguration().get("FILTERS");
        if (webHook.isActive() && this.jqlIssueMatcher.match(jql, issue.getKey())) {
            Map<String, Object> data = this.transitionMapper.toMap(transientVars, this.getCallerUser(transientVars, args), issue);
            this.eventPublisher.publish((Object)new WebHookPostFunctionEvent(webHook.getId(), data, (Issue)issue));
        }
    }
}

