/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.web.component;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.jira.webhooks.WebhooksHtmlPanel;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.HelpPath;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class AbstractWebHooksHtmlPanel
implements WebhooksHtmlPanel {
    private final TemplateRenderer templateRenderer;
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final ApplicationProperties applicationProperties;
    private final HelpPathResolver helpPathResolver;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final String templatePath;

    public AbstractWebHooksHtmlPanel(String templateName, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport AutoCompleteJsonGenerator autoCompleteJsonGenerator, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport HelpPathResolver helpPathResolver, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.templatePath = "/templates/" + templateName;
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.autoCompleteJsonGenerator = (AutoCompleteJsonGenerator)Preconditions.checkNotNull((Object)autoCompleteJsonGenerator);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.helpPathResolver = (HelpPathResolver)Preconditions.checkNotNull((Object)helpPathResolver);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
    }

    public String getHtml() {
        try {
            HashMap builder = Maps.newHashMap();
            builder.put("action", this);
            builder.put("textutils", new TextUtils());
            StringWriter stringWriter = new StringWriter();
            this.templateRenderer.render(this.templatePath, (Map)ImmutableMap.copyOf((Map)builder), (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    private Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    @HtmlSafe
    public String getVisibleFieldNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(this.getUser(), this.getLocale());
    }

    @HtmlSafe
    public String getVisibleFunctionNamesJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(this.getUser(), this.getLocale());
    }

    @HtmlSafe
    public String getJqlReservedWordsJson() throws JSONException {
        return this.autoCompleteJsonGenerator.getJqlReservedWordsJson();
    }

    public boolean isAutocompleteEnabled() {
        return !this.applicationProperties.getOption("jira.jql.autocomplete.disabled");
    }

    public HelpPath getHelpPath(String path) {
        return this.helpPathResolver.getHelpPath(path);
    }
}

