/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.jira.event.AbstractProjectEvent;
import com.atlassian.jira.plugins.webhooks.spi.JiraWebhookEvent;
import com.atlassian.jira.plugins.webhooks.url.context.ProjectContextSerializer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectEventVariablesProvider
implements UriVariablesProvider<AbstractProjectEvent> {
    private final ProjectContextSerializer contextSerializer;

    public ProjectEventVariablesProvider(ProjectContextSerializer contextSerializer) {
        this.contextSerializer = contextSerializer;
    }

    public Map<String, Object> uriVariables(AbstractProjectEvent projectEvent) {
        Project project = projectEvent.getProject();
        return this.contextSerializer.getContext(project);
    }

    public List<String> supportedUriVariables() {
        return Lists.newArrayList((Object[])new String[]{"project.key", "project.id"});
    }

    public List<WebhookEvent> supportedWebhookEvents() {
        return Lists.newArrayList((Object[])new WebhookEvent[]{JiraWebhookEvent.PROJECT_CREATED, JiraWebhookEvent.PROJECT_UPDATED, JiraWebhookEvent.PROJECT_DELETED, JiraWebhookEvent.PROJECT_ARCHIVED, JiraWebhookEvent.PROJECT_RESTORED});
    }
}

