/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.webhooks.spi.JiraWebhookEvent;
import com.atlassian.jira.plugins.webhooks.url.context.IssueContextSerializer;
import com.atlassian.jira.plugins.webhooks.url.context.ProjectContextSerializer;
import com.atlassian.jira.webhooks.UriVariablesProvider;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhookEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class IssueEventVariablesProvider
implements UriVariablesProvider<IssueRelatedEvent> {
    private final ProjectContextSerializer projectContextSerializer;
    private final IssueContextSerializer issueContextSerializer;

    public IssueEventVariablesProvider(ProjectContextSerializer projectContextSerializer, IssueContextSerializer issueContextSerializer) {
        this.projectContextSerializer = projectContextSerializer;
        this.issueContextSerializer = issueContextSerializer;
    }

    public Map<String, Object> uriVariables(IssueRelatedEvent issueRelatedEvent) {
        Issue issue = issueRelatedEvent.getIssue();
        return ImmutableMap.builder().putAll(this.projectContextSerializer.getContext(issue.getProjectObject())).putAll(this.issueContextSerializer.getContext(issue)).build();
    }

    public List<String> supportedUriVariables() {
        return Lists.newArrayList((Object[])new String[]{"project.key", "project.id", "issue.id", "issue.key"});
    }

    public List<WebhookEvent> supportedWebhookEvents() {
        return Lists.newArrayList((Object[])new WebhookEvent[]{JiraWebhookEvent.ISSUE_CREATED, JiraWebhookEvent.ISSUE_UPDATED, JiraWebhookEvent.ISSUE_DELETED, JiraWebhookEvent.WORKLOG_UPDATED_ISSUE_UPDATED});
    }
}

