/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.spi;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.WebhookInvocation;
import com.atlassian.webhooks.WebhookPayloadBuilder;
import com.atlassian.webhooks.WebhookPayloadProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={WebhookPayloadProvider.class})
public class JiraWebhookPayloadProvider
implements WebhookPayloadProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JiraWebhookPayloadProvider.class);
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public int getWeight() {
        return 100;
    }

    public void setPayload(@Nonnull WebhookInvocation invocation, WebhookPayloadBuilder builder) {
        byte[] body = this.excludeBody(invocation) ? EMPTY_BODY : invocation.getPayload().map(this::toJson).map(bodyString -> bodyString.getBytes(StandardCharsets.UTF_8)).orElse(EMPTY_BODY);
        builder.body(body, MediaType.JSON_UTF_8.toString());
    }

    private boolean excludeBody(WebhookInvocation invocation) {
        return Boolean.parseBoolean((String)invocation.getWebhook().getConfiguration().get("EXCLUDE_BODY"));
    }

    public boolean supports(WebhookInvocation invocation) {
        return true;
    }

    private String toJson(Object payload) {
        try {
            return OBJECT_MAPPER.writeValueAsString(payload);
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception while rendering an event object to a JSON string", (Throwable)e);
            return "";
        }
    }
}

