/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer.version;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.rest.v2.issue.VersionResource;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import java.util.Date;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleVersionBeanFactory {
    private VersionManager versionManager;
    private final DateFieldFormat dateFieldFormat;

    @Autowired
    public SimpleVersionBeanFactory(@ComponentImport VersionManager versionManager, @ComponentImport DateFieldFormat dateFieldFormat) {
        this.versionManager = versionManager;
        this.dateFieldFormat = dateFieldFormat;
    }

    public VersionBean createBean(Version version) {
        Date startDate = version.getStartDate();
        Date releaseDate = version.getReleaseDate();
        String prettyStartDate = null;
        if (startDate != null) {
            prettyStartDate = this.dateFieldFormat.format(startDate);
        }
        String prettyReleaseDate = null;
        if (releaseDate != null) {
            prettyReleaseDate = this.dateFieldFormat.format(releaseDate);
        }
        VersionBean.Builder beanBuilder = new VersionBean.Builder().setArchived(version.isArchived()).setDescription(version.getDescription()).setExpand(null).setId(version.getId()).setName(version.getName()).setOverdue(Boolean.valueOf(this.versionManager.isVersionOverDue(version))).setProjectId(version.getProjectId()).setReleased(version.isReleased()).setUserReleaseDate(prettyReleaseDate).setUserStartDate(prettyStartDate).setSelf(this.createSelfURI(version));
        return beanBuilder.build();
    }

    private URI createSelfURI(Version version) {
        JiraBaseUrls jiraBaseUrls = (JiraBaseUrls)ComponentAccessor.getComponent(JiraBaseUrls.class);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)jiraBaseUrls.restApi2BaseUrl());
        return uriBuilder.path(VersionResource.class).path(version.getId().toString()).build(new Object[0]);
    }
}

