/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer.project;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.plugins.webhooks.serializer.project.ProjectBean;
import com.atlassian.jira.plugins.webhooks.serializer.project.ProjectCategoryBean;
import com.atlassian.jira.plugins.webhooks.serializer.project.ProjectCategoryBeanFactory;
import com.atlassian.jira.plugins.webhooks.serializer.user.UserBean;
import com.atlassian.jira.plugins.webhooks.serializer.user.UserBeanFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.stereotype.Component;

@Component
public class ProjectBeanFactory {
    private final JiraBaseUrls urls;
    private final UserManager userManager;
    private final UserBeanFactory userBeanFactory;
    private final ProjectCategoryBeanFactory projectCategoryBeanFactory;

    public ProjectBeanFactory(@ComponentImport UserManager userManager, @ComponentImport JiraBaseUrls urls, UserBeanFactory userBeanFactory, ProjectCategoryBeanFactory projectCategoryBeanFactory) {
        this.userManager = userManager;
        this.urls = urls;
        this.userBeanFactory = userBeanFactory;
        this.projectCategoryBeanFactory = projectCategoryBeanFactory;
    }

    public ProjectBean createBean(Project project) {
        return new ProjectBean(this.createSelfLink(project), project.getId(), project.getKey(), project.getName(), ProjectJsonBean.getAvatarUrls((Project)project), this.createProjectCategoryBean(project.getProjectCategoryObject()), this.createLeadBean(project), ProjectAssigneeTypes.getPrettyAssigneeType((Long)project.getAssigneeType()));
    }

    private String createSelfLink(Project project) {
        return this.urls.restApi2BaseUrl() + "project/" + project.getId().toString();
    }

    private ProjectCategoryBean createProjectCategoryBean(ProjectCategory projectCategory) {
        return this.projectCategoryBeanFactory.createBean(projectCategory);
    }

    private UserBean createLeadBean(Project project) {
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(project.getLeadUserKey());
        return this.userBeanFactory.createBean(user);
    }
}

