/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer.issue;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventVisitor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.plugins.webhooks.serializer.comment.CommentBeanFactory;
import com.atlassian.jira.plugins.webhooks.serializer.issue.AbstractIssueEventSerializer;
import com.atlassian.jira.plugins.webhooks.serializer.issue.IssueBeanFactory;
import com.atlassian.jira.plugins.webhooks.serializer.user.UserBeanFactory;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.issue.builder.ChangelogBeanBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class IssueEventSerializer
extends AbstractIssueEventSerializer<IssueEvent> {
    private final CommentBeanFactory commentBeanFactory;
    private final UserBeanFactory userBeanFactory;
    private final BeanBuilderFactory restBeanBuilderFactory;
    private final IssueBeanFactory issueBeanFactory;
    private final Collection<Long> noChangeLogEventTypes = Lists.newArrayList((Object[])new Long[]{EventType.ISSUE_COMMENTED_ID, EventType.ISSUE_COMMENT_DELETED_ID, EventType.ISSUE_COMMENT_EDITED_ID, EventType.ISSUE_DELETED_ID});

    public IssueEventSerializer(CommentBeanFactory commentBeanFactory, UserBeanFactory userBeanFactory, @ComponentImport BeanBuilderFactory restBeanBuilderFactory, IssueBeanFactory issueBeanFactory) {
        this.commentBeanFactory = commentBeanFactory;
        this.userBeanFactory = userBeanFactory;
        this.restBeanBuilderFactory = restBeanBuilderFactory;
        this.issueBeanFactory = issueBeanFactory;
    }

    @Override
    protected ImmutableMap.Builder<String, Object> putFields(IssueEvent event, ImmutableMap.Builder<String, Object> builder) {
        builder.put((Object)"issue_event_type_name", (Object)this.mapEventToName(event));
        if (event.getUser() != null) {
            builder.put((Object)"user", (Object)this.userBeanFactory.createBean(event.getUser()));
        }
        builder.put((Object)"issue", (Object)this.issueBeanFactory.createBean(event.getIssue()));
        this.getChangelog(event).ifPresent(changeHistoryBean -> builder.put((Object)"changelog", changeHistoryBean));
        if (event.getComment() != null) {
            builder.put((Object)"comment", (Object)this.commentBeanFactory.createBean(event.getComment()));
        }
        return builder;
    }

    private Optional<? extends ChangelogBean.ChangeHistoryBean> getChangelog(IssueEvent issueEvent) {
        ChangelogBeanBuilder changelogBeanBuilder = this.restBeanBuilderFactory.newChangelogBeanBuilder();
        List allChanges = changelogBeanBuilder.build(issueEvent.getIssue()).getHistories();
        if (this.noChangeLogEventTypes.contains(issueEvent.getEventTypeId()) || allChanges.isEmpty()) {
            return Optional.empty();
        }
        List histories = Lists.reverse((List)allChanges);
        ChangelogBean.ChangeHistoryBean changeHistoryBean = histories.stream().filter(arg_0 -> IssueEventSerializer.getPredicate(issueEvent).apply(arg_0)).findFirst().orElseGet(() -> (ChangelogBean.ChangeHistoryBean)histories.get(0));
        return Optional.of(new NoUserCHB(changeHistoryBean));
    }

    private String mapEventToName(IssueEvent event) {
        return (String)event.accept((IssueEventVisitor)new IssueEventVisitor<String>(){

            public String onIssueCreated(IssueEvent e) {
                return "issue_created";
            }

            public String onIssueUpdated(IssueEvent e) {
                return "issue_updated";
            }

            public String onIssueAssigned(IssueEvent e) {
                return "issue_assigned";
            }

            public String onIssueResolved(IssueEvent e) {
                return "issue_resolved";
            }

            public String onIssueCommented(IssueEvent e) {
                return "issue_commented";
            }

            public String onIssueCommentEdited(IssueEvent e) {
                return "issue_comment_edited";
            }

            public String onIssueCommentDeleted(IssueEvent e) {
                return "issue_comment_deleted";
            }

            public String onIssueClosed(IssueEvent e) {
                return "issue_closed";
            }

            public String onIssueReopened(IssueEvent e) {
                return "issue_reopened";
            }

            public String onIssueDeleted(IssueEvent e) {
                return "issue_deleted";
            }

            public String onIssueMoved(IssueEvent e) {
                return "issue_moved";
            }

            public String onIssueWorkLogged(IssueEvent e) {
                return "issue_work_logged";
            }

            public String onIssueWorkStarted(IssueEvent e) {
                return "issue_work_started";
            }

            public String onIssueWorkStopped(IssueEvent e) {
                return "issue_work_stopped";
            }

            public String onIssueWorklogUpdated(IssueEvent e) {
                return "issue_worklog_updated";
            }

            public String onIssueWorklogDeleted(IssueEvent e) {
                return "issue_worklog_deleted";
            }

            public String onIssueGenericEvent(IssueEvent e) {
                return "issue_generic";
            }

            public String onCustomEvent(IssueEvent e) {
                return "custom";
            }
        });
    }

    private static Predicate<ChangelogBean.ChangeHistoryBean> getPredicate(IssueEvent issueEvent) {
        if (issueEvent.getChangeLog() != null && issueEvent.getChangeLog().get("id") != null) {
            return changeHistoryBean -> {
                if (changeHistoryBean == null) {
                    return false;
                }
                Long changeLogId = (Long)issueEvent.getChangeLog().get("id");
                return Long.valueOf(changeHistoryBean.getId()).equals(changeLogId);
            };
        }
        return changeHistoryBean -> changeHistoryBean != null && StringUtils.equals((CharSequence)issueEvent.getUser().getName(), (CharSequence)changeHistoryBean.getAuthor().getName());
    }

    static class NoUserCHB
    extends ChangelogBean.ChangeHistoryBean {
        private ChangelogBean.ChangeHistoryBean changeHistory;

        NoUserCHB(ChangelogBean.ChangeHistoryBean chb) {
            this.changeHistory = chb;
            this.setId(chb.getId());
            this.setItems(chb.getItems());
        }

        @JsonIgnore
        public UserJsonBean getAuthor() {
            return this.changeHistory.getAuthor();
        }

        @JsonIgnore
        public Date getCreated() {
            return this.changeHistory.getCreated();
        }
    }
}

