/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueBeanBuilder;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueBeanFactory {
    private BeanBuilderFactory restBeanBuilderFactory;

    @Autowired
    public IssueBeanFactory(BeanBuilderFactory restBeanBuilderFactory) {
        this.restBeanBuilderFactory = restBeanBuilderFactory;
    }

    public IssueBean createBean(Issue issue) {
        IssueBeanBuilder issueBeanBuilder = this.restBeanBuilderFactory.newIssueBeanBuilder(issue, IncludedFields.includeAllByDefault(null));
        JiraBaseUrls jiraBaseUrls = (JiraBaseUrls)ComponentAccessor.getComponent(JiraBaseUrls.class);
        UriBuilder uriBuilder = UriBuilder.fromPath((String)jiraBaseUrls.restApi2BaseUrl());
        return issueBeanBuilder.uriBuilder(uriBuilder).build();
    }
}

