/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.jql;

import com.atlassian.jira.plugins.webhooks.jql.JqlIssueMatcher;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookFilter;
import com.atlassian.webhooks.WebhookInvocation;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class JqlEventFilter
implements WebhookFilter {
    private final JqlIssueMatcher jqlIssueMatcher;

    public JqlEventFilter(JqlIssueMatcher jqlIssueMatcher) {
        this.jqlIssueMatcher = jqlIssueMatcher;
    }

    public boolean filter(WebhookInvocation webhookInvocation) {
        return this.getIssueKeyFromPayload(webhookInvocation.getPayload()).map(s -> this.jqlIssueMatcher.match(this.getJql(webhookInvocation.getWebhook()), (String)s)).orElse(true);
    }

    private String getJql(Webhook webhook) {
        String jql = (String)webhook.getConfiguration().get("FILTERS");
        if (jql == null) {
            jql = (String)webhook.getConfiguration().get("filter");
        }
        return jql;
    }

    private Optional<String> getIssueKeyFromPayload(Optional<Object> optionalPayload) {
        return optionalPayload.filter(Map.class::isInstance).map(Map.class::cast).map(payload -> payload.get("issue")).map(IssueBean.class::cast).map(IssueBean::getKey);
    }

    public int getWeight() {
        return 100;
    }
}

