/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.auditing;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.internal.rest.RestWebhook;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraWebhookAuditingHandler {
    static final String NAME_I18N = "webhooks.name";
    static final String DESCRIPTION_I18N = "webhooks.description";
    static final String EVENTS_I18N = "webhooks.events";
    static final String EXCLUDE_DETAILS_I18N = "webhooks.exclude.details";
    static final String URL_I18N = "webhooks.url";
    static final String SECRET_I18N = "webhooks.secret";
    static final String STATE_I18N = "jira.webhooks.auditing.webhook.state";
    static final String JQL_I18N = "jira.webhooks.auditing.webhook.jql";
    static final String ENABLED_I18N = "webhooks.enabled";
    static final String DISABLED_I18N = "webhooks.disabled";
    static final String MASKED_SECRET = "*****";
    static final String WEBHOOK_ADDED_ACTION_I18N = "jira.webhooks.auditing.webhook.added";
    static final String WEBHOOK_DELETED_ACTION_I18N = "jira.webhooks.auditing.webhook.deleted";
    static final String WEBHOOK_MODIFIED_ACTION_I18N = "jira.webhooks.auditing.webhook.modified";
    private static final String JIRA_WEBHOOKS_AUDITING_CATEGORY = "jira.webhooks.auditing.category";
    private static final String WEBHOOK_EVENT_TYPE = "WEBHOOK";
    private static final Logger LOG = LoggerFactory.getLogger(JiraWebhookAuditingHandler.class);
    private static final AuditType WEBHOOK_CREATED = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"jira.webhooks.auditing.category", (String)"jira.webhooks.auditing.webhook.added").build();
    private static final AuditType WEBHOOK_MODIFIED = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"jira.webhooks.auditing.category", (String)"jira.webhooks.auditing.webhook.modified").build();
    private static final AuditType WEBHOOK_DELETED = AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"jira.webhooks.auditing.category", (String)"jira.webhooks.auditing.webhook.deleted").build();
    private final Map<String, Function<RestWebhook, String>> fieldToValueMappers = Map.of("webhooks.name", RestWebhook::getName, "webhooks.description", JiraWebhookAuditingHandler::getDescription, "webhooks.url", RestWebhook::getUrl, "webhooks.secret", JiraWebhookAuditingHandler::getMaskedSecret, "webhooks.exclude.details", this::getExcludeBody, "webhooks.events", JiraWebhookAuditingHandler::getEventsString, "jira.webhooks.auditing.webhook.jql", this::getJqlFilter, "jira.webhooks.auditing.webhook.state", this::getActive);
    private final AuditService auditService;
    private final JiraBaseUrls jiraBaseUrls;
    private final I18nResolver i18nResolver;

    @Autowired
    public JiraWebhookAuditingHandler(@ComponentImport AuditService auditService, @ComponentImport JiraBaseUrls jiraBaseUrls, @ComponentImport I18nResolver i18nResolver) {
        this.auditService = auditService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.i18nResolver = i18nResolver;
    }

    public void onWebhookCreated(RestWebhook webhook) {
        LOG.debug("Adding webhook CREATED audit log for webhook with ID: {}", webhook.get((Object)"id"));
        this.auditService.audit(this.getEvent(WEBHOOK_CREATED, webhook.getName(), webhook.get((Object)"id").toString(), null, webhook));
    }

    public void onWebhookModified(RestWebhook oldWebhook, RestWebhook newWebhook) {
        LOG.debug("Adding webhook UPDATED audit log for webhook with ID: {}", newWebhook.get((Object)"id"));
        this.auditService.audit(this.getEvent(WEBHOOK_MODIFIED, newWebhook.getName(), newWebhook.get((Object)"id").toString(), oldWebhook, newWebhook));
    }

    public void onWebhookDeleted(RestWebhook webhook) {
        LOG.debug("Adding webhook DELETED audit log for webhook with ID: {}", webhook.get((Object)"id"));
        this.auditService.audit(this.getEvent(WEBHOOK_DELETED, webhook.getName(), webhook.get((Object)"id").toString(), webhook, null));
    }

    private AuditEvent getEvent(AuditType type, String objectName, String webhookId, RestWebhook oldWebhook, RestWebhook newWebhook) {
        return AuditEvent.builder((AuditType)type).affectedObject(AuditResource.builder((String)objectName, (String)WEBHOOK_EVENT_TYPE).id(webhookId).uri(this.getWebhooksUri(webhookId)).build()).changedValues(this.getChangedValues(oldWebhook, newWebhook)).build();
    }

    private List<ChangedValue> getChangedValues(RestWebhook oldWebhook, RestWebhook newWebhook) {
        return this.fieldToValueMappers.entrySet().stream().map(mapperEntry -> ChangedValue.fromI18nKeys((String)((String)mapperEntry.getKey())).from(oldWebhook == null ? null : (String)((Function)mapperEntry.getValue()).apply(oldWebhook)).to(newWebhook == null ? null : (String)((Function)mapperEntry.getValue()).apply(newWebhook)).build()).filter(value -> !Objects.equals(value.getFrom(), value.getTo())).toList();
    }

    private static String getEventsString(RestWebhook webhook) {
        return String.join((CharSequence)", ", webhook.getEvents());
    }

    private String getJqlFilter(RestWebhook webhook) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)((String)webhook.getConfiguration().get("FILTERS")), (CharSequence)this.i18nResolver.getText("webhooks.admin.jql.empty"));
    }

    private String getExcludeBody(RestWebhook webhook) {
        return Boolean.parseBoolean((String)webhook.getConfiguration().get("EXCLUDE_BODY")) ? this.i18nResolver.getText(ENABLED_I18N) : this.i18nResolver.getText(DISABLED_I18N);
    }

    private static String getMaskedSecret(RestWebhook webhook) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)MASKED_SECRET, (CharSequence)((String)webhook.getConfiguration().get("SECRET")));
    }

    private String getActive(RestWebhook webhook) {
        return Boolean.TRUE.equals(webhook.getActive()) ? this.i18nResolver.getText(ENABLED_I18N) : this.i18nResolver.getText(DISABLED_I18N);
    }

    private static String getDescription(RestWebhook webhook) {
        return (String)webhook.getConfiguration().get("DESCRIPTION");
    }

    private String getWebhooksUri(String webhookId) {
        return this.jiraBaseUrls.baseUrl() + "/plugins/servlet/webhooks#" + webhookId;
    }
}

