/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SubTasksProgressContextProvider
implements CacheableContextProvider {
    private final SubTaskManager subTaskManager;
    private final JiraAuthenticationContext authenticationContext;

    public SubTasksProgressContextProvider(SubTaskManager subTaskManager, JiraAuthenticationContext authenticationContext) {
        this.subTaskManager = subTaskManager;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get("issue");
        SubTaskBean subTaskBean = this.getSubTaskBean(issue, context);
        paramsBuilder.add((Object)"subTaskProgress", (Object)subTaskBean.getSubTaskProgress());
        return paramsBuilder.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        User user = (User)context.get("user");
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private SubTaskBean getSubTaskBean(Issue issue, Map<String, Object> context) {
        HttpServletRequest request = this.getRequest(context);
        if (request != null) {
            SubTaskBean subtaskBean = (SubTaskBean)request.getAttribute("atl.jira.subtask.bean." + issue.getKey());
            if (subtaskBean != null) {
                return subtaskBean;
            }
            subtaskBean = this.subTaskManager.getSubTaskBean(issue.getGenericValue(), this.authenticationContext.getLoggedInUser());
            request.setAttribute("atl.jira.subtask.bean." + issue.getKey(), (Object)subtaskBean);
            return subtaskBean;
        }
        return this.subTaskManager.getSubTaskBean(issue.getGenericValue(), this.authenticationContext.getLoggedInUser());
    }

    protected HttpServletRequest getRequest(Map<String, Object> context) {
        return ExecutingHttpRequest.get();
    }
}

