/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class PeopleBlockContextProvider
implements CacheableContextProvider {
    private final ApplicationProperties applicationProperties;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final UserFormatManager userFormatManager;
    private final VoteManager voteManager;
    private final WatcherManager watcherManager;

    public PeopleBlockContextProvider(ApplicationProperties applicationProperties, AvatarService avatarService, JiraAuthenticationContext authenticationContext, FieldScreenRendererFactory fieldScreenRendererFactory, FieldVisibilityManager fieldVisibilityManager, IssueManager issueManager, PermissionManager permissionManager, UserFormatManager userFormatManager, VoteManager voteManager, WatcherManager watcherManager) {
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.authenticationContext = authenticationContext;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.userFormatManager = userFormatManager;
        this.voteManager = voteManager;
        this.watcherManager = watcherManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        Action action = (Action)context.get("action");
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        paramsBuilder.add((Object)"issue", (Object)issue);
        paramsBuilder.add((Object)"user", (Object)user);
        paramsBuilder.add((Object)"peopleComponent", (Object)this);
        paramsBuilder.add((Object)"assigneeVisible", (Object)this.isAssigneeVisible(issue));
        paramsBuilder.add((Object)"reporterVisible", (Object)this.isReporterVisible(issue));
        paramsBuilder.add((Object)"showAssignToMe", (Object)this.showAssignToMe(user, issue));
        List watchers = this.watcherManager.getCurrentWatcherUsernames(issue);
        paramsBuilder.add((Object)"watchers", (Object)watchers);
        paramsBuilder.add((Object)"watching", (Object)(user != null && watchers.contains(user.getUsername()) ? 1 : 0));
        paramsBuilder.add((Object)"voting", (Object)this.voteManager.hasVoted(user, issue));
        paramsBuilder.add((Object)"isResolved", (Object)(issue.getResolutionObject() != null ? 1 : 0));
        String reporterId = issue.getReporterId();
        paramsBuilder.add((Object)"isCurrentUserReporter", (Object)(StringUtils.isNotBlank((String)reporterId) && user != null && reporterId.equals(user.getKey()) ? 1 : 0));
        paramsBuilder.add((Object)"isLoggedIn", (Object)(user != null ? 1 : 0));
        paramsBuilder.add((Object)"votingEnabled", (Object)this.applicationProperties.getOption("jira.option.voting"));
        paramsBuilder.add((Object)"watchingEnabled", (Object)this.applicationProperties.getOption("jira.option.watching"));
        paramsBuilder.add((Object)"canManageWatcherList", (Object)this.permissionManager.hasPermission(32, issue, user));
        paramsBuilder.add((Object)"canViewVotersAndWatchers", (Object)this.permissionManager.hasPermission(31, issue, user));
        paramsBuilder.add((Object)"userCustomFields", this.createUserFieldHelpers(issue, action));
        return paramsBuilder.toMap();
    }

    private boolean showAssignToMe(ApplicationUser currentUser, Issue issue) {
        return currentUser != null && !currentUser.getKey().equals(issue.getAssigneeId()) && this.permissionManager.hasPermission(13, issue, currentUser) && this.permissionManager.hasPermission(17, issue, currentUser) && this.issueManager.isEditable(issue);
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        return issue.getId() + 47L + (user == null ? "" : user.getUsername());
    }

    private List<CustomFieldHelper> createUserFieldHelpers(Issue issue, Action action) {
        FieldScreenRenderer screenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isCustomUserField());
        List fieldScreenRenderLayoutItems = screenRenderer.getAllScreenRenderItems();
        ArrayList<CustomFieldHelper> userCustomFields = new ArrayList<CustomFieldHelper>();
        for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderLayoutItems) {
            userCustomFields.add(new CustomFieldHelper(fieldScreenRenderLayoutItem, action, issue));
        }
        return userCustomFields;
    }

    private boolean isAssigneeVisible(Issue issue) {
        return this.isFieldVisible(issue, "assignee");
    }

    private boolean isReporterVisible(Issue issue) {
        return this.isFieldVisible(issue, "reporter");
    }

    private boolean isFieldVisible(Issue issue, String field) {
        return !this.fieldVisibilityManager.isFieldHidden(issue.getProjectObject().getId(), field, issue.getIssueTypeObject().getId());
    }

    public String getAssigneeDisplayHtml(Issue issue) {
        if (issue == null) {
            return "";
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("avatarURL", this.getAvatarURL(issue.getAssignee()));
        parameters.put("defaultFullName", this.authenticationContext.getI18nHelper().getText("common.status.unassigned"));
        return this.userFormatManager.formatUserkey(issue.getAssigneeId(), "avatarFullNameHover", "issue_summary_assignee", parameters);
    }

    public String getReporterDisplayHtml(Issue issue) {
        if (issue == null) {
            return "";
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("avatarURL", this.getAvatarURL(issue.getReporter()));
        return this.userFormatManager.formatUserkey(issue.getReporterId(), "avatarFullNameHover", "issue_summary_reporter", parameters);
    }

    private String getAvatarURL(User user) {
        ApplicationUser applicationUser = ApplicationUsers.from((User)user);
        return this.avatarService.getAvatarURL(this.authenticationContext.getUser(), applicationUser, Avatar.Size.NORMAL).toString();
    }

    public class CustomFieldHelper {
        private final FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem;
        private final Action action;
        private final Issue issue;

        private CustomFieldHelper(FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem, Action action, Issue issue) {
            this.fieldScreenRenderLayoutItem = fieldScreenRenderLayoutItem;
            this.action = action;
            this.issue = issue;
        }

        public String getHtml() {
            return this.fieldScreenRenderLayoutItem.getViewHtml(this.action, null, this.issue);
        }

        public String getName() {
            return this.fieldScreenRenderLayoutItem.getOrderableField().getName();
        }

        public String getId() {
            return this.fieldScreenRenderLayoutItem.getOrderableField().getId();
        }

        public String getFieldType() {
            CustomField customField = (CustomField)this.fieldScreenRenderLayoutItem.getOrderableField();
            return customField.getCustomFieldType().getDescriptor().getKey();
        }

        public String getFieldTypeCompleteKey() {
            CustomField customField = (CustomField)this.fieldScreenRenderLayoutItem.getOrderableField();
            return customField.getCustomFieldType().getDescriptor().getCompleteKey();
        }
    }
}

