/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.plugin.issueview.IssueViewModuleDescriptor;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class DetailsBlockContextProvider
implements ContextProvider {
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectComponentManager projectComponentManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final LabelUtil labelUtil;
    private final FieldManager fieldManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    private VersionManager versionManager;

    public DetailsBlockContextProvider(PluginAccessor pluginAccessor, JiraAuthenticationContext authenticationContext, ProjectComponentManager projectComponentManager, FieldVisibilityManager fieldVisibilityManager, LabelUtil labelUtil, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, IssueManager issueManager, PermissionManager permissionManager, WorkflowManager workflowManager, VersionManager versionManager) {
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.projectComponentManager = projectComponentManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.labelUtil = labelUtil;
        this.fieldManager = fieldManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.versionManager = versionManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        GenericValue securityLevel;
        Collection versions;
        Collection components;
        MapBuilder paramsBuilder = MapBuilder.newBuilder((Map)JiraVelocityUtils.getDefaultVelocityParams(context, (JiraAuthenticationContext)this.authenticationContext));
        Issue issue = (Issue)context.get("issue");
        Action action = (Action)context.get("action");
        User user = this.authenticationContext.getLoggedInUser();
        paramsBuilder.add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper());
        paramsBuilder.add((Object)"issue", (Object)issue);
        paramsBuilder.add((Object)"summaryComponent", (Object)this);
        paramsBuilder.add((Object)"fieldVisibility", (Object)this.fieldVisibilityManager);
        paramsBuilder.add((Object)"issueViews", this.getIssueViews());
        paramsBuilder.add((Object)"canEdit", (Object)this.issueManager.isEditable(issue, user));
        paramsBuilder.add((Object)"hasViewWorkflowPermission", (Object)this.permissionManager.hasPermission(45, issue, user));
        JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
        if (workflow != null) {
            paramsBuilder.add((Object)"workflowName", (Object)workflow.getName());
        }
        paramsBuilder.add((Object)"viewReadOnlyWorkflowUrl", (Object)ViewReadOnlyWorkflowUrl.get(workflow, issue));
        Long projectId = issue.getProjectObject().getId();
        paramsBuilder.add((Object)"projectHasComponents", (Object)(!this.projectComponentManager.findAllForProject(projectId).isEmpty() ? 1 : 0));
        if (!this.fieldVisibilityManager.isFieldHidden("components", issue) && (components = issue.getComponentObjects()) != null && !components.isEmpty()) {
            paramsBuilder.add((Object)"components", (Object)components);
        }
        paramsBuilder.add((Object)"projectHasVersions", (Object)(!this.versionManager.getVersions(projectId).isEmpty() ? 1 : 0));
        if (!this.fieldVisibilityManager.isFieldHidden("versions", issue) && (versions = issue.getAffectedVersions()) != null && !versions.isEmpty()) {
            paramsBuilder.add((Object)"versions", (Object)versions);
        }
        if (!this.fieldVisibilityManager.isFieldHidden("fixVersions", issue) && (versions = issue.getFixVersions()) != null && !versions.isEmpty()) {
            paramsBuilder.add((Object)"fixVersions", (Object)versions);
        }
        if (!this.fieldVisibilityManager.isFieldHidden("security", issue) && (securityLevel = issue.getSecurityLevel()) != null) {
            paramsBuilder.add((Object)"securitylevel", (Object)securityLevel);
        }
        if (!this.fieldVisibilityManager.isFieldHidden("labels", issue)) {
            Set labels = issue.getLabels();
            paramsBuilder.add((Object)"labelUtil", (Object)this.labelUtil);
            paramsBuilder.add((Object)"labels", (Object)labels);
            paramsBuilder.add((Object)"remoteUser", (Object)this.authenticationContext.getLoggedInUser());
        }
        if (!this.fieldVisibilityManager.isFieldHidden("environment", issue) && StringUtils.isNotBlank((String)issue.getEnvironment())) {
            paramsBuilder.add((Object)"renderedEnvironmentHtml", (Object)this.getRenderedEnvironmentFieldValue(issue, action));
            paramsBuilder.add((Object)"environment", (Object)issue.getEnvironment());
        }
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isStandardViewIssueCustomField());
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        paramsBuilder.add((Object)"tabs", this.getTabs(fieldScreenRenderTabs, issue, action));
        return paramsBuilder.toMap();
    }

    private Collection<IssueViewModuleDescriptor> getIssueViews() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueViewModuleDescriptor.class);
    }

    private String getRenderedEnvironmentFieldValue(Issue issue, Action action) {
        OrderableField environmentField = this.fieldManager.getOrderableField("environment");
        FieldScreenRenderer renderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
        FieldLayoutItem fieldLayoutItem = renderer.getFieldScreenRenderLayoutItem(environmentField).getFieldLayoutItem();
        return environmentField.getViewHtml(fieldLayoutItem, action, issue);
    }

    private List<SimpleTab> getTabs(List<FieldScreenRenderTab> fieldScreenRenderTabs, Issue issue, Action action) {
        CollectionBuilder tabs = CollectionBuilder.newBuilder();
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderTabs) {
            tabs.add((Object)new SimpleTab(fieldScreenRenderTab, issue, action));
        }
        return tabs.asList();
    }

    private static class ViewReadOnlyWorkflowUrl {
        private ViewReadOnlyWorkflowUrl() {
        }

        private static String get(JiraWorkflow workflow, Issue issue) {
            if (workflow != null) {
                StringBuilder href = new StringBuilder("/plugins/servlet/workflow/thumbnail/getThumbnail?workflowName=").append(JiraUrlCodec.encode((String)workflow.getName()));
                StepDescriptor step = workflow.getLinkedStep(issue.getStatusObject());
                if (step != null) {
                    href.append("&stepId=").append(Integer.toString(step.getId()));
                }
                href.append("&width=full&height=full");
                return href.toString();
            }
            return "";
        }
    }

    public static class SimpleField {
        private String id = null;
        private String fieldType = null;
        private String fieldTypeCompleteKey = null;
        private String name = null;
        private String styleClass = null;
        private boolean isShowField = false;
        private String fieldHtml = null;

        public SimpleField(FieldScreenRenderLayoutItem layoutItem, Issue issue, Action action) {
            CustomField orderableField = (CustomField)layoutItem.getOrderableField();
            CustomFieldTypeModuleDescriptor descriptor = orderableField.getCustomFieldType().getDescriptor();
            Object value = orderableField.getValue(issue);
            boolean bl = this.isShowField = value != null && descriptor.isViewTemplateExists();
            if (this.isShowField) {
                this.id = orderableField.getId();
                this.name = orderableField.getName();
                this.styleClass = "type-" + descriptor.getKey();
                this.fieldType = descriptor.getKey();
                this.fieldTypeCompleteKey = descriptor.getCompleteKey();
                if (this.styleClass.equals("type-textarea") && ((String)value).length() > 255) {
                    this.styleClass = this.styleClass + " twixified";
                }
                this.fieldHtml = orderableField.getViewHtml(layoutItem.getFieldLayoutItem(), action, issue, MapBuilder.build((Object)"view_issue", (Object)Boolean.TRUE));
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public boolean isShowField() {
            return this.isShowField;
        }

        public String getFieldHtml() {
            return this.fieldHtml;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public String getFieldTypeCompleteKey() {
            return this.fieldTypeCompleteKey;
        }
    }

    public static class SimpleTab {
        private final String name;
        private final List<SimpleField> fields;

        public SimpleTab(FieldScreenRenderTab tab, Issue issue, Action action) {
            this.name = tab.getName();
            List layoutItems = tab.getFieldScreenRenderLayoutItems();
            CollectionBuilder fieldBuilder = CollectionBuilder.newBuilder();
            for (FieldScreenRenderLayoutItem layoutItem : layoutItems) {
                fieldBuilder.add((Object)new SimpleField(layoutItem, issue, action));
            }
            this.fields = fieldBuilder.asList();
        }

        public String getName() {
            return this.name;
        }

        public List<SimpleField> getFields() {
            return this.fields;
        }
    }
}

