/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ShareResource {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final ShareService shareService;
    private final IssueService issueService;

    public ShareResource(JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService, ShareService shareService, IssueService issueService) {
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.shareService = shareService;
        this.issueService = issueService;
    }

    @POST
    @Path(value="issue/{key}")
    public Response shareIssue(@PathParam(value="key") String issueKey, ShareBean shareBean) {
        ShareService.ValidateShareIssueResult result;
        User user = this.authenticationContext.getLoggedInUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueKey);
        if (!issueResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueResult.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        Set<String> userNames = shareBean.getUsernames();
        if (!new JiraUserPreferences(user).getBoolean("user.notify.own.changes") && userNames.contains(user.getName())) {
            userNames.remove(user.getName());
            shareBean.getEmails().add(user.getEmailAddress());
        }
        if (!(result = this.shareService.validateShareIssue(user, shareBean, (Issue)issueResult.getIssue())).isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        this.shareService.shareIssue(result);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="filter/{id}")
    public Response shareSearchRequest(@PathParam(value="id") Long id, ShareBean shareBean) {
        User user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)context, id);
        if (filter == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)context.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        ShareService.ValidateShareSearchRequestResult result = this.shareService.validateShareSearchRequest(user, shareBean, filter);
        if (!result.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        this.shareService.shareSearchRequest(result);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="search")
    public Response shareSearch(ShareBean shareBean) {
        User user = this.authenticationContext.getLoggedInUser();
        ShareService.ValidateShareSearchRequestResult result = this.shareService.validateShareSearchRequest(user, shareBean, null);
        if (!result.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection())).cacheControl(CacheControl.never()).build();
        }
        this.shareService.shareSearchRequest(result);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

