/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBean;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;

class UserListResolver {
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private final SchemeManager schemeManager;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    final Collection<FilterPermissionBean> permissions;

    public UserListResolver(JiraAuthenticationContext authContext, UserManager userManager, GroupManager groupManager, ProjectManager projectManager, PermissionManager permissionManager, ProjectRoleManager projectRoleManager, SchemeManager schemeManager, Collection<FilterPermissionBean> permissions) {
        this.authContext = authContext;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.schemeManager = schemeManager;
        this.permissions = permissions;
    }

    public Collection<User> getShareUsers() {
        ImmutableSet.Builder sharedUsersBuilder = ImmutableSet.builder();
        if (this.permissionManager.hasPermission(27, this.authContext.getUser())) {
            for (FilterPermissionBean sharePermission : this.permissions) {
                String type = sharePermission.getType();
                if (type.equals(ShareType.Name.GLOBAL.toString())) {
                    return ImmutableList.copyOf(this.getAllActiveUsers());
                }
                if (type.equals(ShareType.Name.GROUP.toString())) {
                    GroupJsonBean groupJsonBean = sharePermission.getGroup();
                    Group group = this.groupManager.getGroup(groupJsonBean.getName());
                    sharedUsersBuilder.addAll(this.activeUsers(this.groupManager.getUsersInGroup(group)));
                    continue;
                }
                if (type.equals(ShareType.Name.PROJECT.toString())) {
                    ProjectBean projectBean = sharePermission.getProject();
                    Project project = this.projectManager.getProjectObjByName(projectBean.getName());
                    ProjectRoleBean roleBean = sharePermission.getRole();
                    if (roleBean == null) {
                        sharedUsersBuilder.addAll(this.activeUsers(this.schemeManager.getUsers(Long.valueOf(10L), project)));
                        continue;
                    }
                    ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleBean.name);
                    sharedUsersBuilder.addAll(this.activeUsers(this.projectRoleManager.getProjectRoleActors(projectRole, project).getUsers()));
                    continue;
                }
                throw new IllegalStateException("Unknown share type of: " + type);
            }
        }
        return sharedUsersBuilder.build();
    }

    private Iterable<User> getAllActiveUsers() {
        return this.activeUsers(this.userManager.getUsers());
    }

    Iterable<User> activeUsers(Collection<User> users) {
        return Iterables.filter(users, (Predicate)new Predicate<User>(){

            public boolean apply(@Nullable User user) {
                return user != null && user.isActive();
            }
        });
    }
}

