/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.expand.PagedListWrapper;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.google.common.base.Supplier;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class UserBeanListWrapper
extends PagedListWrapper<UserBean, User> {
    private final Ordering<User> userOrdering = Ordering.from((Comparator)new UserBestNameComparator());
    private final JiraBaseUrls jiraBaseUrls;
    private final Supplier<Collection<User>> sharedUsersSupplier;

    private UserBeanListWrapper() {
        this(null, Collections.emptyList(), 0);
    }

    public UserBeanListWrapper(JiraBaseUrls jiraBaseUrls, Collection<User> sharedUsers, int maxResults) {
        super(sharedUsers.size(), maxResults);
        this.jiraBaseUrls = jiraBaseUrls;
        this.sharedUsersSupplier = Suppliers.ofInstance(sharedUsers);
    }

    @Override
    public UserBean fromBackedObject(User user) {
        return new UserBeanBuilder(this.jiraBaseUrls).user(user).buildShort();
    }

    @Override
    public int getBackingListSize() {
        return ((Collection)this.sharedUsersSupplier.get()).size();
    }

    @Override
    public List<User> getOrderedList(int startIndex, int endIndex) {
        List sortedUsers = this.userOrdering.leastOf((Iterable)this.sharedUsersSupplier.get(), endIndex + 1);
        return sortedUsers.subList(startIndex, endIndex + 1);
    }
}

