/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.rest.api.issue.JsonTypeBean;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.IssueResourceExamples;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class SearchResultsBean {
    public static final SearchResultsBean DOC_EXAMPLE = new SearchResultsBean(0, 50, 1, Arrays.asList(IssueResourceExamples.ISSUE_SHORT));
    public String expand;
    public Integer startAt;
    public Integer maxResults;
    public Integer total;
    public List<IssueBean> issues;
    public Set<String> warningMessages;
    public HashMap<String, String> names;
    public Map<String, JsonTypeBean> schema;

    public SearchResultsBean() {
    }

    public SearchResultsBean(Integer startAt, Integer maxResults, Integer total, List<IssueBean> issues) {
        this.startAt = startAt;
        this.maxResults = maxResults;
        this.total = total;
        this.issues = issues;
        this.pullUpSchemaAndNames(issues);
    }

    public SearchResultsBean(Integer startAt, Integer maxResults, Integer total, List<IssueBean> issues, Set<String> warningMessages) {
        this(startAt, maxResults, total, issues);
        if (warningMessages != null && !warningMessages.isEmpty()) {
            this.warningMessages = warningMessages;
        }
    }

    private void pullUpSchemaAndNames(List<IssueBean> issues) {
        for (IssueBean issue : issues) {
            this.pullUpNames(issue);
            this.pullUpSchema(issue);
        }
    }

    private void pullUpNames(IssueBean issue) {
        this.pullUpExpandParam(issue, "names");
        this.addToNames(issue.names());
        issue.names(null);
    }

    private void pullUpSchema(IssueBean issue) {
        this.pullUpExpandParam(issue, "schema");
        this.addToSchema(issue.schema());
        issue.schema(null);
    }

    private void pullUpExpandParam(IssueBean issue, String field) {
        Set<String> fieldToRemove = Collections.singleton(field);
        Sets.SetView issueExpand = Sets.difference((Set)Sets.newHashSet(issue.expand()), fieldToRemove);
        issue.expand((Iterable<String>)issueExpand);
        HashSet searchExpand = Sets.newHashSet(StringList.fromQueryParam(this.expand).asList());
        this.expand = StringList.fromList((Iterable<String>)Sets.union((Set)searchExpand, Collections.singleton(field))).toQueryParam();
    }

    private void addToSchema(@Nullable Map<String, JsonTypeBean> issueSchema) {
        if (issueSchema != null) {
            if (this.schema == null) {
                this.schema = Maps.newHashMap();
            }
            this.schema.putAll(issueSchema);
        }
    }

    private void addToNames(@Nullable Map<String, String> issueNames) {
        if (issueNames != null) {
            if (this.names == null) {
                this.names = Maps.newHashMap();
            }
            this.names.putAll(issueNames);
        }
    }
}

