/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="jql/autocompletedata")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchAutoCompleteResource {
    public static final String DOC_EXAMPLE = "{\"visibleFieldNames\": [{\"value\":\"affectedVersion\",\"displayName\":\"affectedVersion\",\"auto\":\"true\",\"orderable\":\"true\",\"searchable\":\"true\",\"operators\":[\"=\",\"!=\",\"in\",\"not in\",\"is\",\"is not\",\"<\",\"<=\",\">\",\">=\"],\"types\":[\"com.atlassian.jira.project.version.Version\"]},{\"value\":\"assignee\",\"displayName\":\"assignee\",\"auto\":\"true\",\"orderable\":\"true\",\"searchable\":\"true\",\"operators\":[\"!=\",\"was not in\",\"not in\",\"was not\",\"is\",\"was in\",\"was\",\"=\",\"in\",\"changed\",\"is not\"],\"types\":[\"com.atlassian.crowd.embedded.api.User\"]}],\"visibleFunctionNames\": {\"value\":\"currentLogin()\",\"displayName\":\"currentLogin()\",\"types\":[\"java.util.Date\"]},{\"value\":\"currentUser()\",\"displayName\":\"currentUser()\",\"types\":[\"com.atlassian.crowd.embedded.api.User\"]}],\"jqlReservedWords\": \"empty\",\"and\",\"or\",\"in\",\"distinct\"]}";
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;

    public SearchAutoCompleteResource(AutoCompleteJsonGenerator autoCompleteJsonGenerator, JiraAuthenticationContext authContext, I18nHelper i18n) {
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.authContext = authContext;
        this.i18n = i18n;
    }

    @GET
    public Response getAutoComplete() {
        User user = this.authContext.getLoggedInUser();
        Locale locale = this.authContext.getLocale();
        try {
            String entity = "{\"visibleFieldNames\": " + this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(user, locale) + "," + "\"visibleFunctionNames\": " + this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(user, locale) + "," + "\"jqlReservedWords\": " + this.autoCompleteJsonGenerator.getJqlReservedWordsJson() + "}";
            return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
        }
        catch (JSONException e) {
            throw new RESTException(ErrorCollection.of(this.i18n.getText("rest.error.generating.response")).reason(ErrorCollection.Reason.SERVER_ERROR));
        }
    }
}

