/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.api.expand.PagedListWrapper;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.search.FilterSubscriptionBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class FilterSubscriptionBeanListWrapper
extends PagedListWrapper<FilterSubscriptionBean, GenericValue> {
    private FilterSubscriptionService filterSubscriptionService;
    private SearchRequest filter;
    private ApplicationUser user;
    private UserManager userManager;
    private JiraBaseUrls jiraBaseUrls;
    private LazyReference<Collection<GenericValue>> visibleSubscriptionsReference = new LazyReference<Collection<GenericValue>>(){

        protected Collection<GenericValue> create() throws Exception {
            return FilterSubscriptionBeanListWrapper.this.filterSubscriptionService.getVisibleSubscriptions(FilterSubscriptionBeanListWrapper.this.user, FilterSubscriptionBeanListWrapper.this.filter);
        }
    };

    public FilterSubscriptionBeanListWrapper(FilterSubscriptionService filterSubscriptionService, UserManager userManager, ApplicationUser user, SearchRequest filter, JiraBaseUrls jiraBaseUrls) {
        super(0, 1000);
        this.filter = filter;
        this.filterSubscriptionService = filterSubscriptionService;
        this.user = user;
        this.userManager = userManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    private FilterSubscriptionBeanListWrapper() {
        super(0, 0);
    }

    public static FilterSubscriptionBeanListWrapper empty() {
        return new FilterSubscriptionBeanListWrapper(null, null, null, null, null);
    }

    @Override
    public FilterSubscriptionBean fromBackedObject(GenericValue filterSubscription) {
        return new FilterSubscriptionBeanBuilder().subscription(filterSubscription).build();
    }

    @Override
    public int getBackingListSize() {
        return ((Collection)this.visibleSubscriptionsReference.get()).size();
    }

    @Override
    public List<GenericValue> getOrderedList(int startIndex, int endIndex) {
        ImmutableList subscriptions = Ordering.natural().immutableSortedCopy((Iterable)this.visibleSubscriptionsReference.get());
        return subscriptions.subList(startIndex, endIndex + 1);
    }

    class FilterSubscriptionBeanBuilder {
        private GenericValue subscription;

        FilterSubscriptionBeanBuilder() {
        }

        public FilterSubscriptionBeanBuilder subscription(GenericValue subscription) {
            this.subscription = subscription;
            return this;
        }

        private UserBean buildUserBean() {
            String userKey = this.subscription.getString("username");
            return new UserBeanBuilder(FilterSubscriptionBeanListWrapper.this.jiraBaseUrls).user(FilterSubscriptionBeanListWrapper.this.userManager.getUserByKey(userKey)).buildShort();
        }

        private GroupJsonBean buildGroupBean() {
            String groupName = this.subscription.getString("group");
            return this.validGroupName(groupName) ? new GroupJsonBeanBuilder(FilterSubscriptionBeanListWrapper.this.jiraBaseUrls).name(groupName).build() : null;
        }

        private boolean validGroupName(String groupName) {
            return TextUtils.stringSet((String)groupName) && FilterSubscriptionBeanListWrapper.this.userManager.getGroup(groupName) != null;
        }

        public FilterSubscriptionBean build() {
            return new FilterSubscriptionBean(this.subscription.getLong("id"), this.buildUserBean(), this.buildGroupBean());
        }
    }
}

