/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.fields.ColumnService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.EditableSearchRequestColumnLayoutImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.rest.v2.search.ColumnOptions;
import com.atlassian.jira.rest.v2.search.DefaultShareScopeBean;
import com.atlassian.jira.rest.v2.search.FilterBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserSharingPreferencesUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugins.rest.common.expand.EntityCrawler;
import com.atlassian.plugins.rest.common.expand.parameter.DefaultExpandParameter;
import com.atlassian.plugins.rest.common.expand.parameter.ExpandParameter;
import com.atlassian.plugins.rest.common.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.common.expand.resolver.ListWrapperEntityExpanderResolver;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@Path(value="filter")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FilterResource {
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final FavouritesService favouritesService;
    private final SearchService searchService;
    private final BeanBuilderFactory beanBuilderFactory;
    private final UserSharingPreferencesUtil userSharingPreferencesUtil;
    private final PermissionManager permissionsManager;
    private final UserPreferencesManager userPreferencesManager;
    private final ColumnLayoutManager columnLayoutManager;
    private final ColumnService columnService;
    private final SharedEntity.SharePermissions sharePermissions = SharedEntity.SharePermissions.PRIVATE;

    public FilterResource(JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService, VelocityRequestContextFactory velocityRequestContextFactory, FavouritesService favouritesService, SearchService searchService, BeanBuilderFactory beanBuilderFactory, UserSharingPreferencesUtil userSharingPreferencesUtil, PermissionManager permissionsManager, UserPreferencesManager userPreferencesManager, ColumnLayoutManager columnLayoutManager, ColumnService columnService) {
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.favouritesService = favouritesService;
        this.searchService = searchService;
        this.beanBuilderFactory = beanBuilderFactory;
        this.userSharingPreferencesUtil = userSharingPreferencesUtil;
        this.permissionsManager = permissionsManager;
        this.userPreferencesManager = userPreferencesManager;
        this.columnLayoutManager = columnLayoutManager;
        this.columnService = columnService;
    }

    @Path(value="{id}")
    @GET
    public FilterBean getFilter(@PathParam(value="id") Long id, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        ApplicationUser user = this.authenticationContext.getUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest filter = this.searchRequestService.getFilter((JiraServiceContext)context, id);
        if (filter == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(context.getErrorCollection()));
        }
        return new SearchRequestToFilterBean(uriInfo, expand).apply(filter);
    }

    @POST
    public FilterBean createFilter(FilterBean bean, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        SearchRequest newFilter;
        User user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        if (user == null) {
            context.getErrorCollection().addErrorMessage(i18nHelper.getText("admin.errors.filters.no.user"));
            throw new RESTException(Response.Status.UNAUTHORIZED, ErrorCollection.of(context.getErrorCollection()));
        }
        SearchRequest copiedFromFilter = null;
        Query queryToCopy = null;
        if (bean.getId() != null) {
            copiedFromFilter = this.searchRequestService.getFilter((JiraServiceContext)context, Long.valueOf(Long.parseLong(bean.getId())));
            if (copiedFromFilter == null) {
                throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(context.getErrorCollection()));
            }
            if (bean.getJql() == null) {
                queryToCopy = copiedFromFilter.getQuery();
            }
        }
        if (queryToCopy == null) {
            SearchService.ParseResult parseResult = this.parseAndValidateJql(bean.getJql(), null, user, (JiraServiceContext)context);
            queryToCopy = parseResult.getQuery();
        }
        if ((newFilter = this.processFilterBeanForCreate(bean, queryToCopy, (JiraServiceContext)context)) == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(context.getErrorCollection()));
        }
        newFilter = this.searchRequestService.createFilter((JiraServiceContext)new JiraServiceContextImpl(user), newFilter, bean.isFavourite());
        if (copiedFromFilter != null) {
            this.applyFilterColumnsToFilter(copiedFromFilter, newFilter, (JiraServiceContext)context);
        }
        return this.getFilter(newFilter.getId(), uriInfo, expand);
    }

    @PUT
    @Path(value="{id}")
    public FilterBean editFilter(@PathParam(value="id") Long filterId, FilterBean bean, @Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        SearchService.ParseResult parseResult;
        User user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        if (user == null) {
            throw new RESTException(Response.Status.UNAUTHORIZED, ErrorCollection.of(i18nHelper.getText("admin.errors.filters.no.user")));
        }
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)context, filterId);
        if (bean.getJql() != null && (parseResult = this.parseAndValidateJql(bean.getJql(), filterId, user, (JiraServiceContext)context)).isValid()) {
            searchRequest.setQuery(parseResult.getQuery());
        }
        if (bean.getName() != null) {
            searchRequest.setName(bean.getName());
        }
        if (bean.getDescription() != null) {
            searchRequest.setDescription(bean.getDescription());
        }
        this.searchRequestService.validateFilterForUpdate((JiraServiceContext)context, searchRequest);
        if (context.getErrorCollection().hasAnyErrors()) {
            throw new RESTException(ErrorCollection.of(context.getErrorCollection()));
        }
        this.searchRequestService.updateFilter((JiraServiceContext)context, searchRequest);
        return this.getFilter(searchRequest.getId(), uriInfo, expand);
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteFilter(@PathParam(value="id") Long id) {
        User user = this.authenticationContext.getLoggedInUser();
        JiraServiceContextImpl context = new JiraServiceContextImpl(user);
        this.searchRequestService.deleteFilter((JiraServiceContext)context, id);
        if (context.getErrorCollection().hasAnyErrors()) {
            throw new RESTException(ErrorCollection.of(context.getErrorCollection()));
        }
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void applyFilterColumnsToFilter(SearchRequest filter, SearchRequest newFilter, JiraServiceContext context) {
        User user = this.authenticationContext.getLoggedInUser();
        if (filter != null) {
            try {
                ColumnLayout filterColumnLayout = this.columnLayoutManager.getColumnLayout(user, filter);
                if (filterColumnLayout != null) {
                    this.columnLayoutManager.storeEditableSearchRequestColumnLayout((EditableSearchRequestColumnLayout)new EditableSearchRequestColumnLayoutImpl(filterColumnLayout.getColumnLayoutItems(), user, newFilter));
                }
            }
            catch (ColumnLayoutStorageException e) {
                throw new RuntimeException("Failed to store column layout for filter [" + newFilter.getId() + "]", e);
            }
        }
    }

    private SearchRequest processFilterBeanForCreate(FilterBean bean, Query query, JiraServiceContext context) {
        User user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        SearchRequest request = new SearchRequest(query);
        if (StringUtils.isBlank((String)bean.getName())) {
            context.getErrorCollection().addError("filterName", i18nHelper.getText("saveasfilter.specify.name"));
        }
        request.setName(bean.getName());
        request.setOwnerUserName(user.getName());
        request.setDescription(bean.getDescription());
        request.setPermissions(SharedEntity.SharePermissions.PRIVATE);
        if (this.isEditEnabled()) {
            request.setPermissions(this.userSharingPreferencesUtil.getDefaultSharePermissions(user));
        }
        this.searchRequestService.validateFilterForCreate(context, request);
        if (context.getErrorCollection().hasAnyErrors()) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(context.getErrorCollection()));
        }
        return request;
    }

    private SearchService.ParseResult parseAndValidateJql(String jql, Long filterId, User user, JiraServiceContext context) {
        SearchService.ParseResult parseResult = this.searchService.parseQuery(user, jql);
        if (!parseResult.isValid()) {
            context.getErrorCollection().addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
        } else {
            MessageSet validationResults = this.searchService.validateQuery(user, parseResult.getQuery(), filterId);
            if (validationResults.hasAnyErrors()) {
                context.getErrorCollection().addErrorMessages((Collection)validationResults.getErrorMessages());
            }
        }
        return parseResult;
    }

    @Path(value="favourite")
    @GET
    public List<FilterBean> getFavouriteFilters(@Context UriInfo uriInfo, @QueryParam(value="expand") StringList expand) {
        ApplicationUser user = this.authenticationContext.getUser();
        Collection favouriteFilters = this.searchRequestService.getFavouriteFilters(user);
        Iterable favouriteFilterBeans = Iterables.transform((Iterable)favouriteFilters, (Function)new SearchRequestToFilterBean(uriInfo, expand, true));
        return Lists.newArrayList((Iterable)favouriteFilterBeans);
    }

    @Path(value="defaultShareScope")
    @GET
    public DefaultShareScopeBean getDefaultShareScope() {
        User user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        if (user == null) {
            throw new RESTException(Response.Status.UNAUTHORIZED, ErrorCollection.of(i18nHelper.getText("admin.errors.filters.no.user")));
        }
        DefaultShareScopeBean shareScope = this.isEditEnabled() && this.userSharingPreferencesUtil.getDefaultSharePermissions(user).isGlobal() ? new DefaultShareScopeBean(DefaultShareScopeBean.Scope.GLOBAL) : new DefaultShareScopeBean(DefaultShareScopeBean.Scope.PRIVATE);
        return shareScope;
    }

    @Path(value="defaultShareScope")
    @PUT
    public DefaultShareScopeBean setDefaultShareScope(DefaultShareScopeBean shareScope) {
        User user = this.authenticationContext.getLoggedInUser();
        I18nHelper i18nHelper = this.authenticationContext.getI18nHelper();
        if (user == null) {
            throw new RESTException(Response.Status.UNAUTHORIZED, ErrorCollection.of(i18nHelper.getText("admin.errors.filters.no.user")));
        }
        Preferences userPreferences = this.userPreferencesManager.getPreferences(user);
        try {
            boolean defaultToPrivate = DefaultShareScopeBean.Scope.PRIVATE.equals((Object)shareScope.getScope());
            userPreferences.setBoolean("user.default.share.private", defaultToPrivate);
        }
        catch (AtlassianCoreException e) {
            throw new RESTException(Response.Status.UNAUTHORIZED, ErrorCollection.of(i18nHelper.getText("admin.errors.filters.no.user")));
        }
        return this.getDefaultShareScope();
    }

    @GET
    @Path(value="{id}/columns")
    public Response defaultColumns(@PathParam(value="id") Long filterId) {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        ServiceOutcome outcome = this.columnService.getColumnLayout(currentUser, filterId);
        if (outcome.isValid()) {
            ColumnLayout columnLayout = (ColumnLayout)outcome.getReturnedValue();
            if (columnLayout == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
            }
            List columnLayoutItems = columnLayout.getColumnLayoutItems();
            return Response.ok(ColumnOptions.toColumnOptions(columnLayoutItems)).cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @PUT
    @Path(value="{id}/columns")
    @Consumes(value={"*/*"})
    public Response setColumns(@PathParam(value="id") Long filterId, @FormParam(value="columns") List<String> fields) {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        ServiceResult outcome = this.columnService.setColumns(currentUser, filterId, fields);
        if (outcome.isValid()) {
            return Response.ok().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    @DELETE
    @Path(value="{id}/columns")
    @Consumes(value={"*/*"})
    public Response resetColumns(@PathParam(value="id") Long filterId) {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        ServiceResult outcome = this.columnService.resetColumns(currentUser, filterId);
        if (outcome.isValid()) {
            return Response.noContent().cacheControl(CacheControl.never()).build();
        }
        throw new RESTException(ErrorCollection.of(outcome.getErrorCollection()));
    }

    private SharedEntity.SharePermissions getPermissions() {
        return this.sharePermissions;
    }

    private boolean isEditEnabled() {
        return this.permissionsManager.hasPermission(22, this.getLoggedInUser());
    }

    private User getLoggedInUser() {
        return this.authenticationContext.getLoggedInUser();
    }

    private class SearchRequestToFilterBean
    implements Function<SearchRequest, FilterBean> {
        private final UriInfo uriInfo;
        private final ExpandParameter expand;
        private final Boolean isFavourite;
        private final EntityExpanderResolver expandResolver = new ListWrapperEntityExpanderResolver();
        private final EntityCrawler entityCrawler = new EntityCrawler();

        public SearchRequestToFilterBean(UriInfo uriInfo, StringList expand) {
            this(uriInfo, expand, null);
        }

        public SearchRequestToFilterBean(UriInfo uriInfo, StringList expand, Boolean isFavourite) {
            this.uriInfo = uriInfo;
            this.expand = new DefaultExpandParameter(expand != null ? expand.asList() : Collections.emptyList());
            this.isFavourite = isFavourite;
        }

        public FilterBean apply(SearchRequest filter) {
            ApplicationUser user = FilterResource.this.authenticationContext.getUser();
            String canonicalBaseUrl = FilterResource.this.velocityRequestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
            boolean isFavourite = this.isFavourite == null ? user != null && FilterResource.this.favouritesService.isFavourite(user, (SharedEntity)filter) : this.isFavourite;
            FilterBean bean = FilterResource.this.beanBuilderFactory.newFilterBeanBuilder().filter(filter).context(this.uriInfo, canonicalBaseUrl).owner(ApplicationUsers.toDirectoryUser((ApplicationUser)filter.getOwner())).favourite(isFavourite).build();
            this.entityCrawler.crawl((Object)bean, this.expand, this.expandResolver);
            return bean;
        }
    }
}

