/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.rest.v2.search.FilterBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBean;
import com.atlassian.jira.rest.v2.search.FilterResource;
import com.atlassian.jira.rest.v2.search.FilterSubscriptionBeanListWrapper;
import com.atlassian.jira.rest.v2.search.SearchResource;
import com.atlassian.jira.rest.v2.search.UserBeanListWrapper;
import com.atlassian.jira.rest.v2.search.UserListResolver;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.user.util.UserManager;
import java.net.URI;
import java.util.ArrayList;
import javax.ws.rs.core.UriInfo;

public class FilterBeanBuilder {
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectBeanFactory projectBeanFactory;
    private final ShareTypeFactory shareTypeFactory;
    private final UserManager userManager;
    private final JqlStringSupport jqlStringSupport;
    private final GroupManager groupManager;
    private final SchemeManager schemeManager;
    private final FilterSubscriptionService filterSubscriptionService;
    private final JiraBaseUrls jiraBaseUrls;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private SearchRequest filter;
    private UriInfo context;
    private String canoncialBaseUrl;
    private User owner = null;
    private boolean favourite = false;

    public FilterBeanBuilder(JiraAuthenticationContext authContext, ProjectManager projectManager, PermissionManager permissionManager, ProjectRoleManager projectRoleManager, ProjectBeanFactory projectBeanFactory, ShareTypeFactory shareTypeFactory, UserManager userManager, JqlStringSupport jqlStringSupport, GroupManager groupManager, SchemeManager schemeManager, FilterSubscriptionService filterSubscriptionService, JiraBaseUrls jiraBaseUrls, ProjectRoleBeanFactory projectRoleBeanFactory) {
        this.authContext = authContext;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectRoleManager = projectRoleManager;
        this.projectBeanFactory = projectBeanFactory;
        this.shareTypeFactory = shareTypeFactory;
        this.userManager = userManager;
        this.jqlStringSupport = jqlStringSupport;
        this.groupManager = groupManager;
        this.schemeManager = schemeManager;
        this.filterSubscriptionService = filterSubscriptionService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
    }

    public FilterBeanBuilder filter(SearchRequest filter) {
        this.filter = filter;
        return this;
    }

    public FilterBeanBuilder context(UriInfo context, String canoncialBaseUrl) {
        this.context = context;
        this.canoncialBaseUrl = canoncialBaseUrl;
        return this;
    }

    public FilterBeanBuilder owner(User owner) {
        this.owner = owner;
        return this;
    }

    public FilterBeanBuilder favourite(boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    public FilterBean build() {
        if (this.filter != null) {
            if (this.context == null || this.canoncialBaseUrl == null) {
                throw new IllegalStateException("No context set.");
            }
            UserBean owner = new UserBeanBuilder(this.jiraBaseUrls).user(this.owner).buildShort();
            URI issueNavUri = URI.create(this.canoncialBaseUrl + "/secure/IssueNavigator.jspa?mode=hide&requestId=" + this.filter.getId());
            URI self = this.context.getBaseUriBuilder().path(FilterResource.class).path(Long.toString(this.filter.getId())).build(new Object[0]);
            String JQL = this.jqlStringSupport.generateJqlString(this.filter.getQuery());
            URI searchUri = this.context.getBaseUriBuilder().path(SearchResource.class).queryParam("jql", new Object[]{"{0}"}).build(new Object[]{JQL});
            ArrayList<FilterPermissionBean> sharePermissions = new ArrayList<FilterPermissionBean>();
            for (SharePermission sharePermission : this.filter.getPermissions()) {
                ShareTypePermissionChecker permissionChecker;
                ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                if (type == null || !(permissionChecker = type.getPermissionsChecker()).hasPermission(this.authContext.getLoggedInUser(), sharePermission)) continue;
                sharePermissions.add(this.buildSharePermission(sharePermission));
            }
            FilterSubscriptionBeanListWrapper filterSubscribtionBeanListWrapper = new FilterSubscriptionBeanListWrapper(this.filterSubscriptionService, this.userManager, this.authContext.getUser(), this.filter, this.jiraBaseUrls);
            UserListResolver userListResolver = new UserListResolver(this.authContext, this.userManager, this.groupManager, this.projectManager, this.permissionManager, this.projectRoleManager, this.schemeManager, sharePermissions);
            UserBeanListWrapper userBeanListWrapper = new UserBeanListWrapper(this.jiraBaseUrls, userListResolver.getShareUsers(), 1000);
            return new FilterBean(self, Long.toString(this.filter.getId()), this.filter.getName(), this.filter.getDescription(), owner, JQL, issueNavUri, searchUri, this.favourite, sharePermissions, filterSubscribtionBeanListWrapper, userBeanListWrapper);
        }
        return null;
    }

    private FilterPermissionBean buildSharePermission(SharePermission input) {
        FilterPermissionBeanBuilder builder = new FilterPermissionBeanBuilder().sharePermission(input);
        ShareType.Name type = input.getType();
        if (!ShareType.Name.GLOBAL.equals((Object)type)) {
            if (ShareType.Name.PROJECT.equals((Object)type)) {
                Long projectId = Long.valueOf(input.getParam1());
                Project project = this.projectManager.getProjectObj(projectId);
                ProjectBean projectBean = this.projectBeanFactory.shortProject(project);
                builder.project(projectBean);
                String roleKey = input.getParam2();
                if (null != roleKey) {
                    Long id = Long.valueOf(roleKey);
                    ProjectRole projectRole = this.projectRoleManager.getProjectRole(id);
                    ProjectRoleBean projectRoleBean = this.projectRoleBeanFactory.projectRole(project, projectRole);
                    builder.role(projectRoleBean);
                }
            } else if (ShareType.Name.GROUP.equals((Object)type)) {
                String groupKey = input.getParam1();
                builder.group(new GroupJsonBeanBuilder(this.jiraBaseUrls).name(groupKey).build());
            }
        }
        return builder.build();
    }

    static class FilterPermissionBeanBuilder {
        private SharePermission sharePermission;
        private ProjectBean project;
        private ProjectRoleBean role;
        private GroupJsonBean group;

        FilterPermissionBeanBuilder() {
        }

        public FilterPermissionBeanBuilder sharePermission(SharePermission sharePermission) {
            this.sharePermission = sharePermission;
            return this;
        }

        public FilterPermissionBeanBuilder project(ProjectBean project) {
            this.project = project;
            return this;
        }

        public FilterPermissionBeanBuilder role(ProjectRoleBean role) {
            this.role = role;
            return this;
        }

        public FilterPermissionBeanBuilder group(GroupJsonBean group) {
            this.group = group;
            return this;
        }

        public FilterPermissionBean build() {
            return new FilterPermissionBean(this.sharePermission.getId(), this.sharePermission.getType().get(), this.project, this.role, this.group);
        }
    }
}

