/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.preference;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="mypreferences")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CurrentUserPreferencesResource {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserPreferencesManager userPreferencesManager;

    public CurrentUserPreferencesResource(JiraAuthenticationContext jiraAuthenticationContext, UserPreferencesManager userPreferencesManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userPreferencesManager = userPreferencesManager;
    }

    @GET
    public Response getPreference(@QueryParam(value="key") String key) {
        this.fieldValueMustBeProvided("key", key);
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
        String value = preferences.getString(key);
        if (value == null) {
            this.throwError("key not found: '" + key + "'");
        }
        return Response.ok((Object)value).cacheControl(CacheControl.never()).build();
    }

    @PUT
    public Response setPreference(@QueryParam(value="key") String key, String value) throws AtlassianCoreException {
        this.fieldValueMustBeProvided("key", key);
        this.fieldValueMustBeProvided("value", value);
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
        preferences.setString(key, value);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    @DELETE
    public Response removePreference(@QueryParam(value="key") String key) throws AtlassianCoreException {
        this.fieldValueMustBeProvided("key", key);
        ExtendedPreferences preferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
        if (!preferences.containsValue(key)) {
            this.throwError("key not found: '" + key + "'");
        }
        preferences.remove(key);
        return Response.noContent().cacheControl(CacheControl.never()).build();
    }

    private void fieldValueMustBeProvided(String fieldName, String fieldValue) {
        if (fieldValue == null || fieldValue.length() == 0) {
            this.throwError("input parameter '" + fieldName + "' must be provided");
        }
    }

    private void throwError(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errorCollection)).cacheControl(CacheControl.never()).build());
    }
}

