/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.permission;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.permission.PermissionJsonBean;
import com.atlassian.jira.rest.v2.permission.PermissionsJsonBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="mypermissions")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
public class PermissionsResource {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;

    public PermissionsResource(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, ProjectManager projectManager, IssueManager issueManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    public Response getPermissions(@QueryParam(value="projectKey") String projectKey, @QueryParam(value="projectId") String projectId, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="issueId") String issueId) {
        HashMap<String, PermissionJsonBean> permissions = new HashMap<String, PermissionJsonBean>();
        ErrorCollection errors = new ErrorCollection();
        Project project = this.getProjectByIdOrKey(projectKey, projectId, errors);
        Issue issue = this.getIssueByIdOrKey(issueKey, issueId, errors);
        if (errors.hasAnyErrors()) {
            return Response.status((int)errors.getStatus()).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        for (Permissions.Permission permission : Permissions.Permission.values()) {
            if (Permissions.Type.GLOBAL == permission.getType()) continue;
            boolean hasPermission = issue != null ? this.permissionManager.hasPermission(permission.getId(), issue, loggedInUser) : (project != null ? this.permissionManager.hasPermission(permission.getId(), project, loggedInUser) : this.permissionManager.hasProjects(permission.getId(), loggedInUser));
            permissions.put(permission.name(), new PermissionJsonBean(permission, hasPermission, this.jiraAuthenticationContext));
        }
        for (GlobalPermissionType permission : this.globalPermissionManager.getAllGlobalPermissions()) {
            boolean hasPermission = this.globalPermissionManager.hasPermission(permission.getGlobalPermissionKey(), loggedInUser);
            permissions.put(permission.getKey(), new PermissionJsonBean(permission, hasPermission, this.jiraAuthenticationContext));
        }
        return Response.ok((Object)new PermissionsJsonBean(permissions)).cacheControl(CacheControl.never()).build();
    }

    private Project getProjectByIdOrKey(String projectKey, String projectId, ErrorCollection errorCollection) {
        if (StringUtils.isNotBlank((String)projectId)) {
            try {
                Project projectObj = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectId)));
                if (projectObj == null) {
                    errorCollection.addErrorMessage("Could not find project with id " + projectId);
                    errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
                }
                return projectObj;
            }
            catch (NumberFormatException e) {
                errorCollection.addErrorMessage("projectId provided is not valid");
                errorCollection.reason(ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (StringUtils.isNotBlank((String)projectKey)) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                errorCollection.addErrorMessage("Could not find project with key " + projectKey);
                errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
            }
            return project;
        }
        return null;
    }

    private Issue getIssueByIdOrKey(String issueKey, String issueId, ErrorCollection errorCollection) {
        if (StringUtils.isNotBlank((String)issueId)) {
            try {
                MutableIssue issueObj = this.issueManager.getIssueObject(Long.valueOf(Long.parseLong(issueId)));
                if (issueObj == null) {
                    errorCollection.addErrorMessage("Could not find issue with id " + issueId);
                    errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
                }
                return issueObj;
            }
            catch (NumberFormatException e) {
                errorCollection.addErrorMessage("issueId provided is not valid");
                errorCollection.reason(ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (StringUtils.isNotBlank((String)issueKey)) {
            MutableIssue issueObj = this.issueManager.getIssueObject(issueKey);
            if (issueObj == null) {
                errorCollection.addErrorMessage("Could not find issue with key " + issueKey);
                errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
            }
            return issueObj;
        }
        return null;
    }
}

