/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.watcher;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.rest.v2.issue.watcher.WatcherOps;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatcherOpsImpl
implements WatcherOps {
    private final Logger log = LoggerFactory.getLogger(WatcherOpsImpl.class);
    private final WatcherService watcherService;
    private final ContextUriInfo uriInfo;
    private final JiraBaseUrls jiraBaseUrls;

    WatcherOpsImpl(WatcherService watcherService, ContextUriInfo uriInfo, JiraBaseUrls jiraBaseUrls) {
        this.watcherService = watcherService;
        this.uriInfo = uriInfo;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Override
    public WatchersBean getWatchers(Issue issue, User callingUser) {
        return this.buildBean(issue, callingUser, true);
    }

    private WatchersBean buildBean(Issue issue, User callingUser, boolean includeUserList) {
        try {
            WatchersBean.Builder builder = WatchersBean.Builder.create();
            URI watchersUri = this.uriInfo.getBaseUriBuilder().path(IssueResource.class).path(IssueResource.class, "getIssueWatchers").build(new Object[]{issue.getKey()});
            builder.self(watchersUri.toString());
            ServiceOutcome outcome = this.watcherService.getWatchers(issue, callingUser);
            builder.watchCount((Integer)((Pair)outcome.getReturnedValue()).first());
            List watcherUsers = (List)((Pair)outcome.getReturnedValue()).second();
            builder.isWatching(watcherUsers.contains(callingUser));
            if (includeUserList) {
                ArrayList watcherUserBeans = Lists.newArrayList((Iterable)Lists.transform((List)watcherUsers, (Function)new ToUserBean(this.jiraBaseUrls)));
                builder.watchers(watcherUserBeans);
                this.log.trace("Visible watchers on issue '{}': {}", (Object)issue.getKey(), (Object)watcherUserBeans);
            }
            return builder.build();
        }
        catch (WatchingDisabledException e) {
            return null;
        }
    }

    @Override
    public WatchersBean getWatcherCount(Issue issue, User callingUser) {
        return this.buildBean(issue, callingUser, false);
    }

    class ToUserBean
    implements Function<User, UserBean> {
        private final JiraBaseUrls jiraBaseUrls;

        ToUserBean(JiraBaseUrls jiraBaseUrls) {
            this.jiraBaseUrls = jiraBaseUrls;
        }

        public UserBean apply(@Nullable User user) {
            return user != null ? new UserBeanBuilder(this.jiraBaseUrls).user(user).buildShort() : null;
        }
    }
}

