/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleResource;
import com.atlassian.jira.rest.v2.issue.project.RoleActorBean;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorComparator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.Transformed;
import java.util.Collection;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriInfo;

public class ProjectRoleBeanFactoryImpl
implements ProjectRoleBeanFactory {
    private final UriInfo uriInfo;
    private final AvatarService avatarService;

    public ProjectRoleBeanFactoryImpl(UriInfo uriInfo, AvatarService avatarService) {
        this.uriInfo = uriInfo;
        this.avatarService = avatarService;
    }

    @Override
    public ProjectRoleBean projectRole(@Nonnull Project project, @Nonnull ProjectRole projectRole) {
        ProjectRoleBean projectRoleBean = new ProjectRoleBean();
        projectRoleBean.name = projectRole.getName();
        projectRoleBean.id = projectRole.getId();
        projectRoleBean.description = projectRole.getDescription();
        projectRoleBean.self = this.uriInfo.getBaseUriBuilder().path(ProjectRoleResource.class).path(projectRoleBean.id.toString()).build(new Object[]{project.getId()});
        return projectRoleBean;
    }

    @Override
    public ProjectRoleBean projectRole(@Nonnull Project project, @Nonnull ProjectRole projectRole, @Nonnull ProjectRoleActors projectRoleActors, final @Nullable User loggedInUser) {
        TreeSet sortedActors = new TreeSet(RoleActorComparator.COMPARATOR);
        sortedActors.addAll(projectRoleActors.getRoleActors());
        Collection actors = Transformed.collection(sortedActors, (Function)new Function<RoleActor, RoleActorBean>(){

            public RoleActorBean get(RoleActor actor) {
                RoleActorBean bean = RoleActorBean.convert(actor);
                bean.setAvatarUrl(ProjectRoleBeanFactoryImpl.this.avatarService.getAvatarURL(loggedInUser, bean.getName(), Avatar.Size.SMALL));
                return bean;
            }
        });
        ProjectRoleBean projectRoleBean = this.projectRole(project, projectRole);
        projectRoleBean.actors = actors;
        return projectRoleBean;
    }
}

