/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.ProjectJsonBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.v2.issue.IssueTypeBeanBuilder;
import com.atlassian.jira.rest.v2.issue.ProjectResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.issue.component.ComponentBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

public class ProjectBeanFactoryImpl
implements ProjectBeanFactory {
    private static final String EXPAND_FIELDS = "projectKeys";
    private final VersionBeanFactory versionBeanFactory;
    private final UserManager userManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final ProjectManager projectManager;
    private final ProjectRoleBeanFactory projectRoleBeanFactory;
    private final ResourceUriBuilder uriBuilder;
    private final UriInfo uriInfo;
    private final ProjectRoleService projectRoleService;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectBeanFactoryImpl(VersionBeanFactory versionBeanFactory, UriInfo uriInfo, ResourceUriBuilder uriBuilder, ProjectRoleService projectRoleService, JiraAuthenticationContext authenticationContext, UserManager userManager, JiraBaseUrls jiraBaseUrls, ProjectManager projectManager, ProjectRoleBeanFactory projectRoleBeanFactory) {
        this.versionBeanFactory = versionBeanFactory;
        this.uriInfo = uriInfo;
        this.uriBuilder = uriBuilder;
        this.projectRoleService = projectRoleService;
        this.authenticationContext = authenticationContext;
        this.userManager = userManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.projectManager = projectManager;
        this.projectRoleBeanFactory = projectRoleBeanFactory;
    }

    @Override
    public ProjectBean fullProject(Project project, String expand) {
        Preconditions.checkNotNull((Object)project, (Object)"project must not be null");
        Preconditions.checkNotNull((Object)expand, (Object)"expand must not be null");
        ProjectBeanBuilder builder = this.shortProjectBuilder(project);
        builder.expand(EXPAND_FIELDS);
        builder.name(project.getName()).description(project.getDescription());
        String leadUserKey = project.getLeadUserKey();
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(leadUserKey);
        builder.lead(user);
        builder.components(project.getProjectComponents());
        builder.url(project.getUrl());
        builder.versions(project.getVersions());
        builder.assigneeType(project.getAssigneeType());
        builder.email(project.getEmail());
        if (expand.contains(EXPAND_FIELDS)) {
            builder.projectKeys(this.projectManager.getAllProjectKeys(project.getId()));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Collection projectRoles = this.projectRoleService.getProjectRoles(this.authenticationContext.getLoggedInUser(), (ErrorCollection)errorCollection);
        if (!errorCollection.hasAnyErrors()) {
            for (ProjectRole projectRole : projectRoles) {
                URI uri = this.projectRoleBeanFactory.projectRole((Project)project, (ProjectRole)projectRole).self;
                builder.role(projectRole.getName(), uri);
            }
        }
        builder.issueTypes(Lists.newArrayList((Iterable)Collections2.transform((Collection)project.getIssueTypes(), (Function)new Function<IssueType, IssueTypeJsonBean>(){

            public IssueTypeJsonBean apply(IssueType issueType) {
                return new IssueTypeBeanBuilder().jiraBaseUrls(ProjectBeanFactoryImpl.this.jiraBaseUrls).issueType(issueType).context(ProjectBeanFactoryImpl.this.uriInfo).buildShort();
            }
        })));
        return builder.build();
    }

    @Override
    public ProjectBean shortProject(Project project) {
        return this.shortProjectBuilder(project).build();
    }

    private ProjectBeanBuilder shortProjectBuilder(Project project) {
        return new ProjectBeanBuilder().self(this.createSelfLink(project)).key(project.getKey()).name(project.getName()).id(project.getId()).avatarUrls(ProjectJsonBean.getAvatarUrls((Project)project));
    }

    private URI createSelfLink(Project project) {
        return this.uriBuilder.build(this.uriInfo, ProjectResource.class, project.getId().toString());
    }

    private class ProjectBeanBuilder {
        private String expand;
        private URI self;
        private String id;
        private String key;
        private String name;
        private String description;
        private UserBean lead;
        private Collection<ComponentBean> components;
        private String url;
        private String email;
        private Long assigneeType;
        private Collection<VersionBean> versions;
        private Collection<IssueTypeJsonBean> issueTypes;
        private Map<String, URI> roles = new HashMap<String, URI>();
        private Map<String, String> avatarUrls = new HashMap<String, String>();
        private Collection<String> projectKeys;

        public ProjectBeanBuilder expand(String expand) {
            this.expand = expand;
            return this;
        }

        public ProjectBeanBuilder self(URI self) {
            this.self = self;
            return this;
        }

        public ProjectBeanBuilder role(String name, URI uri) {
            this.roles.put(name, uri);
            return this;
        }

        public ProjectBeanBuilder id(Long id) {
            this.id = id == null ? null : id.toString();
            return this;
        }

        public ProjectBeanBuilder key(String key) {
            this.key = key;
            return this;
        }

        public ProjectBeanBuilder issueTypes(Collection<IssueTypeJsonBean> types) {
            this.issueTypes = types;
            return this;
        }

        public ProjectBeanBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ProjectBeanBuilder lead(User lead) {
            this.lead = new UserBeanBuilder(ProjectBeanFactoryImpl.this.jiraBaseUrls).user(lead).buildShort();
            return this;
        }

        public ProjectBeanBuilder lead(ApplicationUser lead) {
            this.lead = new UserBeanBuilder(ProjectBeanFactoryImpl.this.jiraBaseUrls).user(lead).buildShort();
            return this;
        }

        public ProjectBeanBuilder assigneeType(Long assigneeType) {
            this.assigneeType = assigneeType;
            return this;
        }

        public ProjectBeanBuilder components(Collection<? extends ProjectComponent> components) {
            this.components = ComponentBean.asBeans(components, ProjectBeanFactoryImpl.this.jiraBaseUrls);
            return this;
        }

        public ProjectBeanBuilder projectKeys(Collection<String> keys) {
            this.projectKeys = keys;
            return this;
        }

        public ProjectBeanBuilder url(String url) {
            this.url = StringUtils.stripToNull((String)url);
            return this;
        }

        public void email(String email) {
            this.email = StringUtils.stripToNull((String)email);
        }

        public ProjectBeanBuilder versions(Collection<? extends Version> versions) {
            this.versions = ProjectBeanFactoryImpl.this.versionBeanFactory.createVersionBeans(versions);
            return this;
        }

        public ProjectBeanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProjectBeanBuilder avatarUrls(Map<String, String> avatarUrls) {
            this.avatarUrls = avatarUrls;
            return this;
        }

        public ProjectBean build() {
            return new ProjectBean(this.expand, this.self, this.id, this.key, this.name, this.description, this.lead, this.assigneeType, this.url, this.email, this.components, this.versions, this.issueTypes, this.roles, this.avatarUrls, this.projectKeys);
        }
    }
}

