/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.groups;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v2.issue.GroupSuggestionBean;
import com.atlassian.jira.rest.v2.issue.GroupSuggestionsBean;
import com.atlassian.jira.rest.v2.issue.groups.GroupPickerResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.DelimeterInserter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class GroupPickerResourceHelperImpl
implements GroupPickerResourceHelper {
    final Logger LOG = Logger.getLogger(GroupPickerResourceHelperImpl.class);
    public static final String MORE_GROUP_RESULTS_I18N_KEY = "jira.ajax.autocomplete.group.more.results";
    public static final int DEFAULT_MAX_RESULTS = 20;
    private GroupPickerSearchService service;
    private JiraAuthenticationContext authenticationContext;
    private ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;

    public GroupPickerResourceHelperImpl(GroupPickerSearchService service, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, PermissionManager permissionManager) {
        this.service = service;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
    }

    @Override
    public GroupSuggestionsBean findGroupsAsBean(String query, List<String> excludeGroups, Integer maxResults) {
        ArrayList groupBeans = Lists.newArrayList();
        List<Group> groups = Lists.newArrayList();
        if (excludeGroups == null) {
            excludeGroups = ImmutableList.of();
        }
        if (this.permissionManager.hasPermission(27, this.authenticationContext.getLoggedInUser())) {
            groups = this.service.findGroups(query);
        } else {
            Group group = this.service.getGroupByName(query);
            if (group != null) {
                groups.add(group);
            }
        }
        int total = this.limitGroupResults(maxResults, groups, (List<String>)excludeGroups, groupBeans, query);
        String header = this.buildHeader(groupBeans, total);
        return new GroupSuggestionsBean(total, header, groupBeans);
    }

    private int limitGroupResults(Integer maxResults, List<Group> groups, List<String> excludeGroups, List<GroupSuggestionBean> groupBeans, String query) {
        int limit = this.getLimit(maxResults);
        int i = 0;
        int total = groups.size();
        for (Group group : groups) {
            if (i >= limit) break;
            if (!excludeGroups.contains(group.getName())) {
                String matchingHtml = this.buildMatchingHtml(group.getName(), query);
                groupBeans.add(new GroupSuggestionBean(group.getName(), matchingHtml));
                ++i;
                continue;
            }
            --total;
        }
        return total;
    }

    private int getLimit(Integer maxResults) {
        if (maxResults != null) {
            return maxResults;
        }
        int limit = 20;
        try {
            limit = Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        catch (Exception nfe) {
            this.LOG.error((Object)"jira.ajax.autocomplete.limit does not exist or is an invalid number in jira-application.properties. Using default value 20", (Throwable)nfe);
        }
        return limit;
    }

    private String buildMatchingHtml(String group, String query) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>", false);
        String matchingHtml = delimeterInserter.insert(TextUtils.htmlEncode((String)group), new String[]{query});
        return matchingHtml;
    }

    private String buildHeader(Collection<GroupSuggestionBean> groupBeans, int total) {
        return this.authenticationContext.getI18nHelper().getText(MORE_GROUP_RESULTS_I18N_KEY, String.valueOf(groupBeans.size()), String.valueOf(total));
    }
}

