/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.component;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.ComponentResource;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.ofbiz.core.entity.GenericValue;

@XmlRootElement(name="component")
public class ComponentBean {
    public static final ComponentBean DOC_EXAMPLE;
    public static final ComponentBean DOC_EXAMPLE_2;
    public static final ComponentBean DOC_CREATE_EXAMPLE;
    public static final ComponentBean DOC_EDIT_EXAMPLE;
    public static final List<ComponentBean> DOC_EXAMPLE_LIST;
    @XmlElement
    private URI self;
    @XmlElement
    private String id;
    @XmlElement
    private String name;
    @XmlElement
    private String description;
    @XmlElement
    private UserBean lead;
    @XmlElement
    private String leadUserName;
    @XmlElement
    private AssigneeType assigneeType;
    @XmlElement
    private UserBean assignee;
    @XmlElement
    private AssigneeType realAssigneeType;
    @XmlElement
    private UserBean realAssignee;
    @XmlElement
    private boolean isAssigneeTypeValid;
    @XmlElement
    private String project;

    public static Collection<ComponentBean> asBeans(Collection<? extends ProjectComponent> components, JiraBaseUrls jiraBaseUrls) {
        ArrayList<ComponentBean> list = new ArrayList<ComponentBean>();
        for (ProjectComponent projectComponent : components) {
            list.add(ComponentBean.shortComponent(projectComponent, jiraBaseUrls));
        }
        return list;
    }

    public static Collection<ComponentBean> asFullBeans(Collection<? extends ProjectComponent> components, JiraBaseUrls jiraBaseUrls, String projectLeadUserName, long projectAssigneeType, UserManager userManager, AvatarService avatarService, PermissionManager permissionManager, ProjectManager projectManager) {
        ArrayList<ComponentBean> list = new ArrayList<ComponentBean>();
        for (ProjectComponent projectComponent : components) {
            list.add(ComponentBean.fullComponent(projectComponent, jiraBaseUrls, projectLeadUserName, projectAssigneeType, userManager, avatarService, permissionManager, projectManager));
        }
        return list;
    }

    private static ComponentBean shortComponent(ProjectComponent component, JiraBaseUrls jiraBaseUrls) {
        ComponentBean bean = new ComponentBean();
        bean.self = UriBuilder.fromPath((String)jiraBaseUrls.restApi2BaseUrl()).path(ComponentResource.class).path(component.getId().toString()).build(new Object[0]);
        bean.id = component.getId().toString();
        bean.description = component.getDescription();
        bean.name = component.getName();
        return bean;
    }

    public static ComponentBean fullComponent(ProjectComponent component, JiraBaseUrls jiraBaseUrls, String projectLeadUserName, long projectAssigneeType, UserManager userManager, AvatarService avatarService, PermissionManager permissionManager, ProjectManager projectManager) {
        String projectLeadUserKey;
        ComponentBean bean = ComponentBean.shortComponent(component, jiraBaseUrls);
        bean.description = component.getDescription();
        String lead = component.getLead();
        ApplicationUser user = userManager.getUserByKeyEvenWhenUnknown(lead);
        ApplicationUser projectLeadUser = userManager.getUserByName(projectLeadUserName);
        String string = projectLeadUserKey = projectLeadUser == null ? null : projectLeadUser.getKey();
        if (user != null) {
            bean.lead = new UserBeanBuilder(jiraBaseUrls).user(user).buildShort();
        }
        ComponentBean.populateAssignee(bean, component, projectLeadUserKey, projectAssigneeType, jiraBaseUrls, userManager, permissionManager, projectManager);
        return bean;
    }

    private static void populateAssignee(ComponentBean bean, ProjectComponent component, String projectLeadUserKey, long projectAssigneeType, JiraBaseUrls jiraBaseUrls, UserManager userManager, PermissionManager permissionManager, ProjectManager projectManager) {
        ApplicationUser user;
        String configuredAssigneeName = null;
        switch ((int)component.getAssigneeType()) {
            case 1: {
                configuredAssigneeName = component.getLead();
                break;
            }
            case 2: {
                configuredAssigneeName = projectLeadUserKey;
                break;
            }
            case 0: {
                configuredAssigneeName = projectAssigneeType == 2L ? projectLeadUserKey : null;
            }
        }
        long realAssigneeType = ComponentUtils.getAssigneeType((GenericValue)component.getGenericValue(), (Long)component.getAssigneeType());
        String realAssigneeName = null;
        switch ((int)realAssigneeType) {
            case 1: {
                realAssigneeName = component.getLead();
                break;
            }
            case 2: {
                realAssigneeName = projectLeadUserKey;
                break;
            }
            case 0: {
                realAssigneeName = projectAssigneeType == 2L ? projectLeadUserKey : null;
            }
        }
        bean.assigneeType = AssigneeType.getAssigneeType(component.getAssigneeType());
        if (configuredAssigneeName != null) {
            user = userManager.getUserByKeyEvenWhenUnknown(configuredAssigneeName);
            bean.assignee = user != null ? new UserBeanBuilder(jiraBaseUrls).user(user).buildShort() : null;
        }
        bean.realAssigneeType = AssigneeType.getAssigneeType(realAssigneeType);
        if (realAssigneeName != null) {
            boolean assignable;
            user = userManager.getUserByKeyEvenWhenUnknown(realAssigneeName);
            bean.realAssignee = user != null ? new UserBeanBuilder(jiraBaseUrls).user(user).buildShort() : null;
            Project project = projectManager.getProjectObj(component.getProjectId());
            bean.isAssigneeTypeValid = assignable = permissionManager.hasPermission(17, project, user);
        }
        if (bean.realAssigneeType == AssigneeType.UNASSIGNED) {
            bean.isAssigneeTypeValid = ComponentAssigneeTypes.isAssigneeTypeValid((GenericValue)component.getGenericValue(), (Long)AssigneeType.UNASSIGNED.getId());
        }
        if (bean.assigneeType != bean.realAssigneeType) {
            bean.isAssigneeTypeValid = false;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UserBean getLead() {
        return this.lead;
    }

    public URI getSelf() {
        return this.self;
    }

    public String getLeadUserName() {
        return this.leadUserName;
    }

    public AssigneeType getAssigneeType() {
        return this.assigneeType;
    }

    public String getProject() {
        return this.project;
    }

    static {
        DOC_EXAMPLE_LIST = new ArrayList<ComponentBean>();
        ComponentBean component = new ComponentBean();
        component.self = Examples.restURI("component", "10000");
        component.id = "10000";
        component.name = "Component 1";
        component.description = "This is a JIRA component";
        component.lead = UserBean.SHORT_DOC_EXAMPLE;
        component.assigneeType = AssigneeType.PROJECT_LEAD;
        component.assignee = UserBean.SHORT_DOC_EXAMPLE;
        component.realAssigneeType = AssigneeType.PROJECT_LEAD;
        component.realAssignee = UserBean.SHORT_DOC_EXAMPLE;
        DOC_EXAMPLE = component;
        component = new ComponentBean();
        component.self = Examples.restURI("component", "10000");
        component.id = "10050";
        component.name = "PXA";
        component.description = "This is a another JIRA component";
        component.lead = UserBean.SHORT_DOC_EXAMPLE;
        component.assigneeType = AssigneeType.PROJECT_LEAD;
        component.assignee = UserBean.SHORT_DOC_EXAMPLE;
        component.realAssigneeType = AssigneeType.PROJECT_LEAD;
        component.realAssignee = UserBean.SHORT_DOC_EXAMPLE;
        DOC_EXAMPLE_2 = component;
        DOC_EXAMPLE_LIST.add(DOC_EXAMPLE);
        DOC_EXAMPLE_LIST.add(DOC_EXAMPLE_2);
        component = new ComponentBean();
        component.project = "PXA";
        component.name = "Component 1";
        component.description = "This is a JIRA component";
        component.leadUserName = "fred";
        component.assigneeType = AssigneeType.PROJECT_LEAD;
        DOC_CREATE_EXAMPLE = component;
        component = new ComponentBean();
        component.name = "Component 1";
        component.description = "This is a JIRA component";
        component.leadUserName = "fred";
        component.assigneeType = AssigneeType.PROJECT_LEAD;
        DOC_EDIT_EXAMPLE = component;
    }

    public static enum AssigneeType {
        PROJECT_DEFAULT(0L),
        COMPONENT_LEAD(1L),
        PROJECT_LEAD(2L),
        UNASSIGNED(3L);

        private final long id;

        private AssigneeType(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        static AssigneeType getAssigneeType(long assigneeType) {
            switch ((short)assigneeType) {
                case 0: {
                    return PROJECT_DEFAULT;
                }
                case 1: {
                    return COMPONENT_LEAD;
                }
                case 2: {
                    return PROJECT_LEAD;
                }
                case 3: {
                    return UNASSIGNED;
                }
            }
            return null;
        }
    }
}

