/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.builder;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.rest.v2.issue.ChangelogBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ChangelogBeanBuilder {
    private final JiraBaseUrls baseUrls;
    private final ChangeHistoryManager changeHistoryManager;
    private final JiraAuthenticationContext authContext;

    public ChangelogBeanBuilder(JiraBaseUrls baseUrls, ChangeHistoryManager changeHistoryManager, JiraAuthenticationContext authContext) {
        this.baseUrls = baseUrls;
        this.changeHistoryManager = changeHistoryManager;
        this.authContext = authContext;
    }

    private ChangelogBean.ChangeHistoryBean makeChangeHistoryBean(ChangeHistory changeHistory) {
        List items = Lists.transform((List)changeHistory.getChangeItemBeans(), (Function)new Function<ChangeItemBean, ChangelogBean.ChangeItemBean>(){

            public ChangelogBean.ChangeItemBean apply(ChangeItemBean from) {
                ChangelogBean.ChangeItemBean item = new ChangelogBean.ChangeItemBean();
                item.setField(from.getField());
                item.setFieldtype(from.getFieldType());
                item.setFrom(from.getFrom());
                item.setFromString(from.getFromString());
                item.setTo(from.getTo());
                item.setToString(from.getToString());
                return item;
            }
        });
        ChangelogBean.ChangeHistoryBean bean = new ChangelogBean.ChangeHistoryBean();
        User author = changeHistory.getAuthorUser();
        bean.setAuthor(UserJsonBean.shortBean((User)author, (JiraBaseUrls)this.baseUrls));
        bean.setCreated(changeHistory.getTimePerformed());
        bean.setId(changeHistory.getId().toString());
        bean.setItems(items);
        return bean;
    }

    public ChangelogBean build(Issue issue) {
        List allChangeHistories = this.changeHistoryManager.getChangeHistoriesForUser(issue, this.authContext.getLoggedInUser());
        ArrayList histories = Lists.newArrayList();
        for (ChangeHistory changeHistoryItem : allChangeHistories) {
            histories.add(this.makeChangeHistoryBean(changeHistoryItem));
        }
        ChangelogBean changelog = new ChangelogBean();
        changelog.setStartAt(0);
        changelog.setMaxResults(histories.size());
        changelog.setTotal(histories.size());
        changelog.setHistories(histories);
        return changelog;
    }
}

