/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.api.expand.PagedListWrapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;

public class UserJsonBeanListWrapper
extends PagedListWrapper<UserJsonBean, User> {
    private final Ordering<User> userOrdering = Ordering.from((Comparator)new UserBestNameComparator());
    private final JiraBaseUrls jiraBaseUrls;
    private final Supplier<List<User>> usersSupplier;

    public UserJsonBeanListWrapper(JiraBaseUrls jiraBaseUrls, List<User> users, int maxResults) {
        super(users.size(), maxResults);
        this.jiraBaseUrls = jiraBaseUrls;
        this.usersSupplier = Suppliers.ofInstance(users);
    }

    @Override
    public UserJsonBean fromBackedObject(User user) {
        return UserJsonBean.shortBean((User)user, (JiraBaseUrls)this.jiraBaseUrls);
    }

    @Override
    public int getBackingListSize() {
        return ((List)this.usersSupplier.get()).size();
    }

    @Override
    public List<User> getOrderedList(int startIndex, int endIndex) {
        List sortedUsers = this.userOrdering.leastOf((Iterable)this.usersSupplier.get(), endIndex + 1);
        return sortedUsers.subList(startIndex, endIndex + 1);
    }
}

