/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserResource;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;

public class UserBeanBuilder {
    private final JiraBaseUrls jiraBaseUrls;
    private ApplicationUser user;
    private String username;
    private List<String> groups;
    private ApplicationUser loggedInUser;
    private boolean loggedInUserIsSet;
    private EmailFormatter emailFormatter;
    private TimeZone timeZone;
    private AvatarService avatarService;
    private URI self;

    public UserBeanBuilder(JiraBaseUrls jiraBaseUrls) {
        Preconditions.checkNotNull((Object)jiraBaseUrls, (Object)"JiraBaseUrls cannot be null!");
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public UserBeanBuilder user(User user) {
        this.user = user == null ? null : ApplicationUsers.from((User)user);
        return this;
    }

    public UserBeanBuilder user(ApplicationUser user) {
        this.user = user;
        return this;
    }

    public UserBeanBuilder user(String username, UserManager userManager) {
        this.username = username;
        this.user = userManager.getUserByName(username);
        return this;
    }

    public UserBeanBuilder groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public UserBeanBuilder self(URI self) {
        this.self = self;
        return this;
    }

    public UserBeanBuilder loggedInUser(User loggedInUser) {
        this.loggedInUser = ApplicationUsers.from((User)loggedInUser);
        this.loggedInUserIsSet = true;
        return this;
    }

    public UserBeanBuilder loggedInUser(ApplicationUser loggedInUser) {
        this.loggedInUser = loggedInUser;
        this.loggedInUserIsSet = true;
        return this;
    }

    public UserBeanBuilder timeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
        return this;
    }

    public UserBeanBuilder emailFormatter(EmailFormatter emailFormatter) {
        this.emailFormatter = emailFormatter;
        return this;
    }

    public UserBeanBuilder avatarService(AvatarService avatarService) {
        this.avatarService = avatarService;
        return this;
    }

    public UserBean buildShort() {
        if (this.user != null) {
            return new UserBean(this.self != null ? this.self : this.createSelfLink(), this.user.getKey(), this.user.getUsername(), this.user.getDisplayName(), this.user.isActive(), this.getAvatarURLs());
        }
        return this.buildSimple();
    }

    public UserBean buildFull() {
        if (this.user == null) {
            return this.buildMid();
        }
        if (this.groups == null) {
            throw new IllegalStateException("groups not set");
        }
        if (this.emailFormatter == null) {
            throw new IllegalStateException("emailFormatter not set");
        }
        if (!this.loggedInUserIsSet) {
            throw new IllegalStateException("loggedInUser not set");
        }
        if (this.timeZone == null) {
            throw new IllegalStateException("timeZone not set");
        }
        if (this.avatarService == null) {
            throw new IllegalStateException("avatarService not set");
        }
        return new UserBean(this.self != null ? this.self : this.createSelfLink(), this.user.getKey(), this.user.getUsername(), this.user.getDisplayName(), this.user.isActive(), this.emailFormatter.formatEmail(this.user.getEmailAddress(), this.loggedInUser.getDirectoryUser()), Lists.transform(this.groups, (Function)new GroupNameToGroupJsonBean(this.jiraBaseUrls)), this.getAvatarURLs(), this.timeZone);
    }

    public UserBean buildMid() {
        if (this.user == null) {
            return this.buildSimple();
        }
        if (!this.loggedInUserIsSet) {
            throw new IllegalStateException("loggedInUser not set");
        }
        if (this.emailFormatter == null) {
            throw new IllegalStateException("emailFormatter not set");
        }
        if (this.timeZone == null) {
            throw new IllegalStateException("timeZone not set");
        }
        return new UserBean(this.self != null ? this.self : this.createSelfLink(), this.user.getKey(), this.user.getUsername(), this.user.getDisplayName(), this.user.isActive(), this.emailFormatter.formatEmail(this.user.getEmailAddress(), this.loggedInUser.getDirectoryUser()), null, this.getAvatarURLs(), this.timeZone);
    }

    private UserBean buildSimple() {
        if (this.username == null) {
            return null;
        }
        return new UserBean(null, null, this.username, null, false, null);
    }

    protected URI createSelfLink() {
        return UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path(UserResource.class).queryParam("username", new Object[]{"{0}"}).build(new Object[]{this.user.getUsername()});
    }

    private Map<String, URI> getAvatarURLs() {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        HashMap<String, URI> avatarUrls = new HashMap<String, URI>();
        for (Avatar.Size size : Avatar.Size.values()) {
            int px = size.getPixels();
            if (px > 48) continue;
            String sizeName = String.format("%dx%d", px, px);
            avatarUrls.put(sizeName, avatarService.getAvatarAbsoluteURL(this.user, this.user, size));
        }
        return avatarUrls;
    }

    private static class GroupNameToGroupJsonBean
    implements Function<String, GroupJsonBean> {
        private final JiraBaseUrls jiraBaseUrls;

        public GroupNameToGroupJsonBean(JiraBaseUrls jiraBaseUrls) {
            this.jiraBaseUrls = jiraBaseUrls;
        }

        public GroupJsonBean apply(@Nullable String groupName) {
            return new GroupJsonBeanBuilder(this.jiraBaseUrls).name(groupName).build();
        }
    }
}

