/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.rest.api.expand.SimpleListWrapper;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugins.rest.common.expand.Expandable;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
public class UserBean {
    @XmlElement
    private URI self;
    @XmlElement
    private String key;
    @XmlElement
    private String name;
    @XmlElement
    private String emailAddress;
    @XmlElement
    private Map<String, URI> avatarUrls;
    @XmlElement
    private String displayName;
    @XmlElement
    private boolean active;
    @XmlElement
    private String timeZone;
    @Expandable
    @XmlElement
    private SimpleListWrapper<GroupJsonBean> groups;
    @XmlAttribute(name="expand")
    private String expand;
    public static final UserBean DOC_EXAMPLE = new UserBean();
    public static final List<UserBean> DOC_EXAMPLE_LIST = new ArrayList<UserBean>();
    public static final UserBean SHORT_DOC_EXAMPLE = new UserBean();
    public static final UserBean SHORT_DOC_EXAMPLE_2 = new UserBean();
    public static final Map REF_DOC_EXAMPLE;

    UserBean() {
    }

    public UserBean(URI self, String key, String name, String displayName, boolean active, Map<String, URI> avatarUrls) {
        this(self, key, name, displayName, active, null, null, avatarUrls, null);
    }

    public UserBean(URI self, String key, String name, String displayName, boolean active, String emailAddress, List<GroupJsonBean> groups, Map<String, URI> avatarUrls, TimeZone timeZone) {
        this.key = key;
        this.name = name;
        this.self = self;
        this.displayName = displayName;
        this.active = active;
        this.emailAddress = emailAddress;
        this.groups = groups != null ? SimpleListWrapper.of(groups) : null;
        this.avatarUrls = avatarUrls;
        this.timeZone = timeZone != null ? timeZone.getID() : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserBean userBean = (UserBean)o;
        return Objects.equal((Object)this.displayName, (Object)userBean.displayName) && Objects.equal((Object)this.active, (Object)userBean.active) && Objects.equal((Object)this.emailAddress, (Object)userBean.emailAddress) && Objects.equal((Object)this.name, (Object)userBean.name) && Objects.equal((Object)this.timeZone, (Object)userBean.timeZone);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.emailAddress, this.active, this.displayName, this.timeZone, this.name});
    }

    public URI getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Map<String, URI> getAvatarUrls() {
        return this.avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public SimpleListWrapper<GroupJsonBean> getGroups() {
        return this.groups;
    }

    public String getExpand() {
        return this.expand;
    }

    static {
        UserBean.DOC_EXAMPLE.self = Examples.restURI("user?username=fred");
        UserBean.DOC_EXAMPLE.name = "fred";
        UserBean.DOC_EXAMPLE.emailAddress = "fred@example.com";
        UserBean.DOC_EXAMPLE.displayName = "Fred F. User";
        UserBean.DOC_EXAMPLE.active = true;
        UserBean.DOC_EXAMPLE.avatarUrls = MapBuilder.newBuilder().add((Object)"16x16", (Object)Examples.jiraURI("secure/useravatar?size=xsmall&ownerId=fred")).add((Object)"24x24", (Object)Examples.jiraURI("secure/useravatar?size=small&ownerId=fred")).add((Object)"32x32", (Object)Examples.jiraURI("secure/useravatar?size=medium&ownerId=fred")).add((Object)"48x48", (Object)Examples.jiraURI("secure/useravatar?size=large&ownerId=fred")).toMap();
        UserBean.DOC_EXAMPLE.groups = SimpleListWrapper.of(GroupJsonBean.BuildDocExampleUsers((String)"jira-user"), GroupJsonBean.BuildDocExampleUsers((String)"jira-admin"), GroupJsonBean.BuildDocExampleUsers((String)"important"));
        UserBean.DOC_EXAMPLE.timeZone = "Australia/Sydney";
        UserBean.SHORT_DOC_EXAMPLE.self = UserBean.DOC_EXAMPLE.self;
        UserBean.SHORT_DOC_EXAMPLE.name = UserBean.DOC_EXAMPLE.name;
        UserBean.SHORT_DOC_EXAMPLE.displayName = UserBean.DOC_EXAMPLE.displayName;
        UserBean.SHORT_DOC_EXAMPLE.avatarUrls = MapBuilder.newBuilder().add((Object)"16x16", (Object)Examples.jiraURI("secure/useravatar?size=xsmall&ownerId=fred")).add((Object)"24x24", (Object)Examples.jiraURI("secure/useravatar?size=small&ownerId=fred")).add((Object)"32x32", (Object)Examples.jiraURI("secure/useravatar?size=medium&ownerId=fred")).add((Object)"48x48", (Object)Examples.jiraURI("secure/useravatar?size=large&ownerId=fred")).toMap();
        UserBean.SHORT_DOC_EXAMPLE_2.self = Examples.restURI("user?username=andrew");
        UserBean.SHORT_DOC_EXAMPLE_2.name = "andrew";
        UserBean.SHORT_DOC_EXAMPLE_2.displayName = "Andrew Anderson";
        UserBean.SHORT_DOC_EXAMPLE_2.avatarUrls = MapBuilder.newBuilder().add((Object)"16x16", (Object)Examples.jiraURI("secure/useravatar?size=xsmall&ownerId=andrew")).add((Object)"24x24", (Object)Examples.jiraURI("secure/useravatar?size=small&ownerId=andrew")).add((Object)"32x32", (Object)Examples.jiraURI("secure/useravatar?size=medium&ownerId=andrew")).add((Object)"48x48", (Object)Examples.jiraURI("secure/useravatar?size=large&ownerId=andrew")).toMap();
        REF_DOC_EXAMPLE = MapBuilder.newBuilder().add((Object)"name", (Object)"harry").toMap();
        DOC_EXAMPLE_LIST.add(SHORT_DOC_EXAMPLE);
        DOC_EXAMPLE_LIST.add(SHORT_DOC_EXAMPLE_2);
    }
}

